/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.fitness.data.zzs;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawDataPoint
implements SafeParcelable {
    final int mVersionCode;
    public final long zzaue;
    public final long zzauf;
    public final Value[] zzaug;
    public final int zzauX;
    public final int zzauY;
    public final long zzaui;
    public final long zzauj;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new zzn();

    public RawDataPoint(int versionCode, long timestampNanos, long startTimeNanos, Value[] values, int dataSourceIndex, int originalDataSourceIndex, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzaue = timestampNanos;
        this.zzauf = startTimeNanos;
        this.zzauX = dataSourceIndex;
        this.zzauY = originalDataSourceIndex;
        this.zzaui = rawTimestamp;
        this.zzauj = insertionTimeMillis;
        this.zzaug = values;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> dataSources) {
        this.mVersionCode = 4;
        this.zzaue = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.zzauf = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.zzaug = dataPoint.zztD();
        this.zzauX = zzs.zza(dataPoint.getDataSource(), dataSources);
        this.zzauY = zzs.zza(dataPoint.getOriginalDataSource(), dataSources);
        this.zzaui = dataPoint.zztE();
        this.zzauj = dataPoint.zztF();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawDataPoint && this.zza((RawDataPoint)o);
    }

    private boolean zza(RawDataPoint rawDataPoint) {
        return this.zzaue == rawDataPoint.zzaue && this.zzauf == rawDataPoint.zzauf && Arrays.equals(this.zzaug, rawDataPoint.zzaug) && this.zzauX == rawDataPoint.zzauX && this.zzauY == rawDataPoint.zzauY && this.zzaui == rawDataPoint.zzaui;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaue, this.zzauf});
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString(this.zzaug), this.zzauf, this.zzaue, this.zzauX, this.zzauY);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzn.zza(this, parcel, flags);
    }
}

