/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzr;

public class Subscription
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzatP;
    private final DataType zzatO;
    private final long zzavf;
    private final int zzavg;
    public static final Parcelable.Creator<Subscription> CREATOR = new zzr();

    Subscription(int versionCode, DataSource dataSource, DataType dataType, long samplingIntervalMicros, int accuracyMode) {
        this.mVersionCode = versionCode;
        this.zzatP = dataSource;
        this.zzatO = dataType;
        this.zzavf = samplingIntervalMicros;
        this.zzavg = accuracyMode;
    }

    private Subscription(zza builder) {
        this.mVersionCode = 1;
        this.zzatO = builder.zzatO;
        this.zzatP = builder.zzatP;
        this.zzavf = builder.zzavf;
        this.zzavg = builder.zzavg;
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public DataType getDataType() {
        return this.zzatO;
    }

    public int getAccuracyMode() {
        return this.zzavg;
    }

    public long zztU() {
        return this.zzavf;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Subscription && this.zza((Subscription)that);
    }

    private boolean zza(Subscription subscription) {
        return zzw.equal((Object)this.zzatP, (Object)subscription.zzatP) && zzw.equal((Object)this.zzatO, (Object)subscription.zzatO) && this.zzavf == subscription.zzavf && this.zzavg == subscription.zzavg;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP, this.zzatP, this.zzavf, this.zzavg});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("dataSource", (Object)this.zzatP).zzg("dataType", (Object)this.zzatO).zzg("samplingIntervalMicros", (Object)this.zzavf).zzg("accuracyMode", (Object)this.zzavg).toString();
    }

    public String toDebugString() {
        return String.format("Subscription{%s}", this.zzatP == null ? this.zzatO.getName() : this.zzatP.toDebugString());
    }

    public DataType zztV() {
        return this.zzatO == null ? this.zzatP.getDataType() : this.zzatO;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzr.zza(this, dest, flags);
    }

    public static class zza {
        private DataSource zzatP;
        private DataType zzatO;
        private long zzavf = -1L;
        private int zzavg = 2;

        public zza zzb(DataSource dataSource) {
            this.zzatP = dataSource;
            return this;
        }

        public zza zzb(DataType dataType) {
            this.zzatO = dataType;
            return this;
        }

        public Subscription zztW() {
            zzx.zza((this.zzatP != null || this.zzatO != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzatO == null || this.zzatP == null || this.zzatO.equals(this.zzatP.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new Subscription(this);
        }
    }
}

