/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.location.LocationRequest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
implements SafeParcelable {
    private final int mVersionCode;
    private DataSource zzatP;
    private DataType zzatO;
    private zzj zzayN;
    int zzayO;
    int zzayP;
    private final long zzavf;
    private final long zzayQ;
    private final PendingIntent mPendingIntent;
    private final long zzayR;
    private final int zzavg;
    private final List<LocationRequest> zzayS;
    private final long zzayT;
    private final List<Object> zzayU;
    private final zzpp zzayj;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzs();

    SensorRegistrationRequest(int versionCode, DataSource dataSource, DataType dataType, IBinder listenerBinder, int samplingIntervalMicrosInt, int maxDeliveryLatencyMicrosInt, long samplingIntervalMicros, long maxDeliveryLatencyMicros, PendingIntent intent, long fastestIntervalMicros, int accuracyMode, List<LocationRequest> locationRequests, long registrationTimeOutMicros, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzatP = dataSource;
        this.zzatO = dataType;
        this.zzayN = listenerBinder == null ? null : zzj.zza.zzbt(listenerBinder);
        this.zzavf = samplingIntervalMicros == 0L ? (long)samplingIntervalMicrosInt : samplingIntervalMicros;
        this.zzayR = fastestIntervalMicros;
        this.zzayQ = maxDeliveryLatencyMicros == 0L ? (long)maxDeliveryLatencyMicrosInt : maxDeliveryLatencyMicros;
        this.zzayS = locationRequests;
        this.mPendingIntent = intent;
        this.zzavg = accuracyMode;
        this.zzayU = Collections.emptyList();
        this.zzayT = registrationTimeOutMicros;
        this.zzayj = zzpp.zza.zzbR(callback);
    }

    public SensorRegistrationRequest(SensorRequest request, zzj listener, PendingIntent intent, zzpp callback) {
        this(request.getDataSource(), request.getDataType(), listener, intent, request.getSamplingRate(TimeUnit.MICROSECONDS), request.getFastestRate(TimeUnit.MICROSECONDS), request.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), request.getAccuracyMode(), null, Collections.emptyList(), request.zzuA(), callback);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzj listener, PendingIntent pendingIntent, long samplingIntervalMicros, long fastestIntervalMicros, long maxDeliveryLatencyMicros, int accuracyMode, List<LocationRequest> locationRequests, List<Object> clientIdentities, long registrationTimeOutMicros, zzpp callback) {
        this.mVersionCode = 6;
        this.zzatP = dataSource;
        this.zzatO = dataType;
        this.zzayN = listener;
        this.mPendingIntent = pendingIntent;
        this.zzavf = samplingIntervalMicros;
        this.zzayR = fastestIntervalMicros;
        this.zzayQ = maxDeliveryLatencyMicros;
        this.zzavg = accuracyMode;
        this.zzayS = locationRequests;
        this.zzayU = clientIdentities;
        this.zzayT = registrationTimeOutMicros;
        this.zzayj = callback;
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public DataType getDataType() {
        return this.zzatO;
    }

    public PendingIntent zzuu() {
        return this.mPendingIntent;
    }

    public long zzuv() {
        return this.zzayR;
    }

    public long zztU() {
        return this.zzavf;
    }

    public long zzuw() {
        return this.zzayQ;
    }

    public List<LocationRequest> zzux() {
        return this.zzayS;
    }

    public int getAccuracyMode() {
        return this.zzavg;
    }

    public long zzuy() {
        return this.zzayT;
    }

    public IBinder zzui() {
        return this.zzayj == null ? null : this.zzayj.asBinder();
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", this.zzatO, this.zzatP, this.zzavf, this.zzayR, this.zzayQ);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzuz() {
        return this.zzayN == null ? null : this.zzayN.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzs.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)that);
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzw.equal((Object)this.zzatP, (Object)sensorRegistrationRequest.zzatP) && zzw.equal((Object)this.zzatO, (Object)sensorRegistrationRequest.zzatO) && this.zzavf == sensorRegistrationRequest.zzavf && this.zzayR == sensorRegistrationRequest.zzayR && this.zzayQ == sensorRegistrationRequest.zzayQ && this.zzavg == sensorRegistrationRequest.zzavg && zzw.equal(this.zzayS, sensorRegistrationRequest.zzayS);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP, this.zzatO, this.zzayN, this.zzavf, this.zzayR, this.zzayQ, this.zzavg, this.zzayS});
    }
}

