/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzatP;
    private final DataType zzatO;
    private final long zzavf;
    private final long zzayR;
    private final long zzayQ;
    private final int zzavg;
    private final LocationRequest zzayV;
    private final long zzayW;

    private SensorRequest(Builder builder) {
        this.zzatP = builder.zzatP;
        this.zzatO = builder.zzatO;
        this.zzavf = builder.zzavf;
        this.zzayR = builder.zzayR;
        this.zzayQ = builder.zzayQ;
        this.zzavg = builder.zzavg;
        this.zzayV = null;
        this.zzayW = builder.zzayW;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzayV = locationRequest;
        this.zzavf = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzayR = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzayQ = this.zzavf;
        this.zzatO = dataSource.getDataType();
        this.zzavg = SensorRequest.zza(locationRequest);
        this.zzatP = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzayW = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public DataType getDataType() {
        return this.zzatO;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavf, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzayR, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzayQ, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzavg;
    }

    public long zzuA() {
        return this.zzayW;
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("dataSource", (Object)this.zzatP).zzg("dataType", (Object)this.zzatO).zzg("samplingRateMicros", (Object)this.zzavf).zzg("deliveryLatencyMicros", (Object)this.zzayQ).zzg("timeOutMicros", (Object)this.zzayW).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzw.equal((Object)this.zzatP, (Object)sensorRequest.zzatP) && zzw.equal((Object)this.zzatO, (Object)sensorRequest.zzatO) && this.zzavf == sensorRequest.zzavf && this.zzayR == sensorRequest.zzayR && this.zzayQ == sensorRequest.zzayQ && this.zzavg == sensorRequest.zzavg && zzw.equal((Object)this.zzayV, (Object)sensorRequest.zzayV) && this.zzayW == sensorRequest.zzayW;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP, this.zzatO, this.zzavf, this.zzayR, this.zzayQ, this.zzavg, this.zzayV, this.zzayW});
    }

    public static int zzft(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzatP;
        private DataType zzatO;
        private long zzavf = -1L;
        private long zzayR = 0L;
        private long zzayQ = 0L;
        private boolean zzayX = false;
        private int zzavg = 2;
        private long zzayW = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzatP = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzatO = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzx.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzavf = unit.toMicros(interval);
            if (!this.zzayX) {
                this.zzayR = this.zzavf / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzx.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzayX = true;
            this.zzayR = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzx.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzayQ = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzavg = SensorRequest.zzft(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzx.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzx.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzayW = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzx.zza((this.zzatP != null || this.zzatO != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzatO == null || this.zzatP == null || this.zzatO.equals(this.zzatP.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

