/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<DataSet> zzaub;
    private final Status zzTA;
    private final List<Bucket> zzazl;
    private int zzazm;
    private final List<DataSource> zzaul;
    private final List<DataType> zzazn;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = versionCode;
        this.zzTA = status;
        this.zzazm = batchCount;
        this.zzaul = uniqueDataSources;
        this.zzazn = uniqueDataTypes;
        this.zzaub = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzaub.add(new DataSet(object, uniqueDataSources));
        }
        this.zzazl = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzazl.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.mVersionCode = 5;
        this.zzaub = dataSets;
        this.zzTA = status;
        this.zzazl = buckets;
        this.zzazm = 1;
        this.zzaul = new ArrayList<DataSource>();
        this.zzazn = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaub) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzaub) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzaub;
    }

    public List<Bucket> getBuckets() {
        return this.zzazl;
    }

    public int zzuH() {
        return this.zzazm;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzaub);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzazl);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzazl.add(bucket);
    }

    public Status getStatus() {
        return this.zzTA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzTA.equals((Object)dataReadResult.zzTA) && zzw.equal(this.zzaub, dataReadResult.zzaub) && zzw.equal(this.zzazl, dataReadResult.zzazl);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzTA, this.zzaub, this.zzazl});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("status", (Object)this.zzTA).zzg("dataSets", this.zzaub.size() > 5 ? this.zzaub.size() + " data sets" : this.zzaub).zzg("buckets", this.zzazl.size() > 5 ? this.zzazl.size() + " buckets" : this.zzazl).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzuI() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzazl.size());
        for (Bucket bucket : this.zzazl) {
            arrayList.add(new RawBucket(bucket, this.zzaul, this.zzazn));
        }
        return arrayList;
    }

    List<RawDataSet> zzuJ() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzaub.size());
        for (DataSet dataSet : this.zzaub) {
            arrayList.add(new RawDataSet(dataSet, this.zzaul, this.zzazn));
        }
        return arrayList;
    }

    List<DataSource> zztJ() {
        return this.zzaul;
    }

    List<DataType> zzuK() {
        return this.zzazn;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

