/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Session> zzaym;
    private final List<SessionDataSet> zzazu;
    private final Status zzTA;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = versionCode;
        this.zzaym = sessions;
        this.zzazu = Collections.unmodifiableList(sessionDataSets);
        this.zzTA = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = 3;
        this.zzaym = sessions;
        this.zzazu = Collections.unmodifiableList(sessionDataSets);
        this.zzTA = status;
    }

    public static SessionReadResult zzV(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaym;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzx.zzb((boolean)this.zzaym.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzazu) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.zztT().getDataType())) continue;
            arrayList.add(sessionDataSet.zztT());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzx.zzb((boolean)this.zzaym.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzazu) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.zztT());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzuN() {
        return this.zzazu;
    }

    public Status getStatus() {
        return this.zzTA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzTA.equals((Object)sessionReadResult.zzTA) && zzw.equal(this.zzaym, sessionReadResult.zzaym) && zzw.equal(this.zzazu, sessionReadResult.zzazu);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzTA, this.zzaym, this.zzazu});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("status", (Object)this.zzTA).zzg("sessions", this.zzaym).zzg("sessionDataSets", this.zzazu).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

