/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzoq;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class zzop {
    private static final Set<String> zzaxk = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(zzom.zzavz.name, zzom.zzavL.name)));

    public static String zzd(DataPoint dataPoint) {
        DataType dataType = dataPoint.getDataType();
        if (!zzon.zzdp(dataType.getName())) {
            return null;
        }
        for (Field field : dataType.getFields()) {
            double d;
            Value value = dataPoint.getValue(field);
            if (!value.isSet()) {
                if (zzaxk.contains(field.getName())) continue;
                return field.getName() + " not set";
            }
            if (field.getFormat() == 1) {
                d = value.asInt();
            } else {
                if (field.getFormat() != 2) continue;
                d = value.asFloat();
            }
            zzoq.zza zza2 = zzoq.zzud().zzdq(field.getName());
            if (zza2 != null && !zza2.zzh(d)) {
                return "Field out of range";
            }
            zza2 = zzoq.zzud().zzD(dataType.getName(), field.getName());
            if (zza2 == null) continue;
            long l = dataPoint.getTimestampNanos() - dataPoint.zztH();
            if (l == 0L) {
                if (d == 0.0) {
                    return null;
                }
                return "DataPoint out of range";
            }
            double d2 = d / (double)l;
            if (zza2.zzh(d2)) continue;
            return "DataPoint out of range";
        }
        return null;
    }
}

