/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzh;
import java.util.concurrent.TimeUnit;

public class DataUpdateNotification
implements SafeParcelable {
    public static final String ACTION = "com.google.android.gms.fitness.DATA_UPDATE_NOTIFICATION";
    public static final int OPERATION_INSERT = 1;
    public static final int OPERATION_DELETE = 2;
    public static final int OPERATION_UPDATE = 3;
    public static final String EXTRA_DATA_UPDATE_NOTIFICATION = "vnd.google.fitness.data_udpate_notification";
    final int mVersionCode;
    private final long zzawF;
    private final long zzawG;
    private final int zzawH;
    private final DataSource zzavU;
    private final DataType zzavT;
    public static final Parcelable.Creator<DataUpdateNotification> CREATOR = new zzh();

    DataUpdateNotification(int versionCode, long updateStartTimeNanos, long updateEndTimeNanos, int operationType, DataSource dataSource, DataType dataType) {
        this.mVersionCode = versionCode;
        this.zzawF = updateStartTimeNanos;
        this.zzawG = updateEndTimeNanos;
        this.zzawH = operationType;
        this.zzavU = dataSource;
        this.zzavT = dataType;
    }

    public static DataUpdateNotification getDataUpdateNotification(Intent intent) {
        return (DataUpdateNotification)zzc.zza((Intent)intent, (String)EXTRA_DATA_UPDATE_NOTIFICATION, CREATOR);
    }

    public long zzup() {
        return this.zzawF;
    }

    public long zzuq() {
        return this.zzawG;
    }

    public long getUpdateStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzawF, TimeUnit.NANOSECONDS);
    }

    public long getUpdateEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzawG, TimeUnit.NANOSECONDS);
    }

    public int getOperationType() {
        return this.zzawH;
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataUpdateNotification && this.zza((DataUpdateNotification)o);
    }

    private boolean zza(DataUpdateNotification dataUpdateNotification) {
        return this.zzawF == dataUpdateNotification.zzawF && this.zzawG == dataUpdateNotification.zzawG && this.zzawH == dataUpdateNotification.zzawH && zzw.equal((Object)this.zzavU, (Object)dataUpdateNotification.zzavU) && zzw.equal((Object)this.zzavT, (Object)dataUpdateNotification.zzavT);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzawF, this.zzawG, this.zzawH, this.zzavU, this.zzavT});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("updateStartTimeNanos", (Object)this.zzawF).zzg("updateEndTimeNanos", (Object)this.zzawG).zzg("operationType", (Object)this.zzawH).zzg("dataSource", (Object)this.zzavU).zzg("dataType", (Object)this.zzavT).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

