/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzoi;
import java.util.Arrays;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzawe;
    private final List<Integer> zzaAV;
    private final boolean zzaAW;
    private final zzoi zzaAX;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzh();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzawe = dataTypes;
        this.zzaAV = dataSourceTypes;
        this.zzaAW = includeDbOnlySources;
        this.zzaAX = zzoi.zza.zzbD(callback);
    }

    private DataSourcesRequest(Builder builder) {
        this(zzmn.zzb((Object[])builder.zzaAY), Arrays.asList(zzmn.zza((int[])builder.zzaAZ)), builder.zzaAW, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zzoi callback) {
        this(request.zzawe, request.zzaAV, request.zzaAW, callback);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zzoi callback) {
        this.mVersionCode = 4;
        this.zzawe = dataTypes;
        this.zzaAV = dataSourceTypes;
        this.zzaAW = includeDbOnlySources;
        this.zzaAX = callback;
    }

    public List<DataType> getDataTypes() {
        return this.zzawe;
    }

    public List<Integer> zzuT() {
        return this.zzaAV;
    }

    public boolean zzuU() {
        return this.zzaAW;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAX == null ? null : this.zzaAX.asBinder();
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzy((Object)this).zzg("dataTypes", this.zzawe).zzg("sourceTypes", this.zzaAV);
        if (this.zzaAW) {
            zza2.zzg("includeDbOnlySources", (Object)"true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzaAY = new DataType[0];
        private int[] zzaAZ = new int[]{0, 1};
        private boolean zzaAW = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzaAY = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzaAZ = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzx.zza((this.zzaAY.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data type");
            zzx.zza((this.zzaAZ.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

