/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzoj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final String mName;
    private final List<Field> zzawE;
    private final zzoj zzaBa;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzi();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields, IBinder callback) {
        this.mVersionCode = versionCode;
        this.mName = name;
        this.zzawE = Collections.unmodifiableList(fields);
        this.zzaBa = zzoj.zza.zzbE(callback);
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzawE, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest request, zzoj callback) {
        this(request.mName, request.zzawE, callback);
    }

    public DataTypeCreateRequest(String name, List<Field> fields, zzoj callback) {
        this.mVersionCode = 3;
        this.mName = name;
        this.zzawE = Collections.unmodifiableList(fields);
        this.zzaBa = callback;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzawE;
    }

    public IBinder getCallbackBinder() {
        return this.zzaBa == null ? null : this.zzaBa.asBinder();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)o);
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzw.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzw.equal(this.zzawE, dataTypeCreateRequest.zzawE);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mName, this.zzawE});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("name", (Object)this.mName).zzg("fields", this.zzawE).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzi.zza(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzawE = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzawE.contains(field)) {
                this.zzawE.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            zzx.zzb((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzn(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzx.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzx.zza((!this.zzawE.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

