/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzow;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final long zzRD;
    private final long zzavV;
    private final DataSet zzaxn;
    private final zzow zzaAD;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzm();

    DataUpdateRequest(int versionCode, long startTimeMillis, long endTimeMillis, DataSet dataSet, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzaxn = dataSet;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzRD, builder.zzavV, builder.zzaxn, null);
    }

    public DataUpdateRequest(long startTimeMillis, long endTimeMillis, DataSet dataSet, IBinder callback) {
        this.mVersionCode = 1;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzaxn = dataSet;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    public DataUpdateRequest(DataUpdateRequest request, IBinder callback) {
        this(request.zzlO(), request.zzud(), request.getDataSet(), callback);
    }

    public long zzlO() {
        return this.zzRD;
    }

    public long zzud() {
        return this.zzavV;
    }

    public DataSet getDataSet() {
        return this.zzaxn;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzRD, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavV, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataUpdateRequest && this.zzb((DataUpdateRequest)o);
    }

    private boolean zzb(DataUpdateRequest dataUpdateRequest) {
        return this.zzRD == dataUpdateRequest.zzRD && this.zzavV == dataUpdateRequest.zzavV && zzw.equal((Object)this.zzaxn, (Object)dataUpdateRequest.zzaxn);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzRD, this.zzavV, this.zzaxn});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("startTimeMillis", (Object)this.zzRD).zzg("endTimeMillis", (Object)this.zzavV).zzg("dataSet", (Object)this.zzaxn).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzm.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzRD;
        private long zzavV;
        private DataSet zzaxn;

        public Builder setTimeInterval(long startTimeMillis, long endTimeMillis, TimeUnit timeUnit) {
            zzx.zzb((startTimeMillis > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTimeMillis});
            zzx.zzb((endTimeMillis >= startTimeMillis ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTimeMillis});
            this.zzRD = timeUnit.toMillis(startTimeMillis);
            this.zzavV = timeUnit.toMillis(endTimeMillis);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzx.zzb((Object)dataSet, (Object)"Must set the data set");
            this.zzaxn = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            this.zzuV();
            return new DataUpdateRequest(this);
        }

        private void zzuV() {
            zzx.zza((long)this.zzRD, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzx.zza((long)this.zzavV, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzx.zzb((Object)this.zzaxn, (Object)"Must set the data set");
            for (DataPoint dataPoint : this.zzaxn.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                boolean bl = l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < this.zzRD || l2 != 0L && l2 > this.zzavV || l > this.zzavV || l < this.zzRD;
                zzx.zza((!bl ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, this.zzRD, this.zzavV});
            }
        }
    }
}

