/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzph;

public class zzpc
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzx.zzb((Object)dataSet, (Object)"Must set the data set");
        zzx.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzx.zzb((Object)dataSet.getDataSource().zzum(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zza.zza)new zzob.zzc(googleApiClient){

            protected void zza(zzob zzob2) throws RemoteException {
                zzph zzph2 = new zzph((zza.zzb<Status>)this);
                ((zzom)zzob2.zzqJ()).zza(new DataInsertRequest(dataSet, zzph2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza((zza.zza)new zzob.zzc(client){

            protected void zza(zzob zzob2) throws RemoteException {
                zzph zzph2 = new zzph((zza.zzb<Status>)this);
                ((zzom)zzob2.zzqJ()).zza(new DataDeleteRequest(request, zzph2));
            }
        });
    }

    @Override
    public PendingResult<Status> updateData(GoogleApiClient client, final DataUpdateRequest request) {
        zzx.zzb((Object)request.getDataSet(), (Object)"Must set the data set");
        zzx.zza((long)request.zzlO(), (Object)"Must set a non-zero value for startTimeMillis/startTime");
        zzx.zza((long)request.zzud(), (Object)"Must set a non-zero value for endTimeMillis/endTime");
        return client.zza((zza.zza)new zzob.zzc(client){

            protected void zza(zzob zzob2) throws RemoteException {
                zzph zzph2 = new zzph((zza.zzb<Status>)this);
                ((zzom)zzob2.zzqJ()).zza(new DataUpdateRequest(request, (IBinder)zzph2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza((zza.zza)new zzob.zza<DataReadResult>(client){

            protected void zza(zzob zzob2) throws RemoteException {
                zza zza2 = new zza((zza.zzb)this);
                ((zzom)zzob2.zzqJ()).zza(new DataReadRequest(request, zza2));
            }

            protected DataReadResult zzK(Status status) {
                return DataReadResult.zza(status, request);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzK(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza((zza.zza)new zzob.zza<DailyTotalResult>(client){

            protected void zza(zzob zzob2) throws RemoteException {
                zzog.zza zza2 = new zzog.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zza(dailyTotalResult);
                    }
                };
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType);
                ((zzom)zzob2.zzqJ()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzL(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzL(status);
            }
        });
    }

    private static class zza
    extends zzoh.zza {
        private final zza.zzb<DataReadResult> zzamC;
        private int zzaAc = 0;
        private DataReadResult zzaAd = null;

        private zza(zza.zzb<DataReadResult> zzb2) {
            this.zzamC = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    Log.v((String)"Fitness", (String)("Received batch result " + this.zzaAc));
                }
                if (this.zzaAd == null) {
                    this.zzaAd = dataReadResult;
                } else {
                    this.zzaAd.zzb(dataReadResult);
                }
                ++this.zzaAc;
                if (this.zzaAc == this.zzaAd.zzvj()) {
                    this.zzamC.zzs((Object)this.zzaAd);
                }
            }
        }
    }
}

