/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public PendingResult<Status> updateData(GoogleApiClient var1, DataUpdateRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzaCH;
        private DataSource zzaCI;
        private long zzXy;
        private long zzaCJ;
        private String zzaCK;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzaCH = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzXy = timeUnit.toMillis(l);
            this.zzaCJ = timeUnit.toMillis(l2);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzaa.zzb((boolean)dataSource.getDataType().equals((Object)this.zzaCH), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzaCH});
            this.zzaCI = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzaCK = string;
            return this;
        }

        public Intent build() {
            zzaa.zza((this.zzXy > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzaa.zza((this.zzaCJ > this.zzXy ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzaCI.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzXy);
            intent.putExtra("vnd.google.fitness.end_time", this.zzaCJ);
            zzc.zza((SafeParcelable)this.zzaCI, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzk(intent);
        }

        private Intent zzk(Intent intent) {
            if (this.zzaCK == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzaCK);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzaCK, string));
                return intent2;
            }
            return intent;
        }
    }
}

