/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zzqp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final DataSource zzaCI;
    private final DataType zzaCH;
    private final List<DataPoint> zzaDd;
    private final List<DataSource> zzaDe;
    private boolean zzaCW = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.mVersionCode = n;
        this.zzaCI = dataSource;
        this.zzaCH = dataSource.getDataType();
        this.zzaCW = bl;
        this.zzaDd = new ArrayList<DataPoint>(list.size());
        this.zzaDe = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzaDd.add(new DataPoint(this.zzaDe, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.mVersionCode = 3;
        this.zzaCI = (DataSource)((Object)zzaa.zzz((Object)((Object)dataSource)));
        this.zzaCH = dataSource.getDataType();
        this.zzaDd = new ArrayList<DataPoint>();
        this.zzaDe = new ArrayList<DataSource>();
        this.zzaDe.add(this.zzaCI);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.mVersionCode = 3;
        this.zzaCI = DataSet.zzb(list, rawDataSet.zzaDU);
        this.zzaCH = this.zzaCI.getDataType();
        this.zzaDe = list;
        this.zzaCW = rawDataSet.zzaCW;
        List<RawDataPoint> list2 = rawDataSet.zzaDX;
        this.zzaDd = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.zzaDd.add(new DataPoint(this.zzaDe, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzaa.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzaCI);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzaa.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzaCI.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzaCI});
        dataPoint.zzxs();
        zzqp.zze(dataPoint);
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzaDd.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaDe.contains((Object)dataSource)) {
            this.zzaDe.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public DataType getDataType() {
        return this.zzaCI.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaDd);
    }

    public boolean isEmpty() {
        return this.zzaDd.isEmpty();
    }

    public boolean zzxm() {
        return this.zzaCW;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataSet && this.zza((DataSet)((Object)object));
    }

    private boolean zza(DataSet dataSet) {
        return zzz.equal((Object)((Object)this.getDataType()), (Object)((Object)dataSet.getDataType())) && zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)dataSet.zzaCI)) && zzz.equal(this.zzaDd, dataSet.zzaDd) && this.zzaCW == dataSet.zzaCW;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCI});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzxu();
        return String.format("DataSet{%s %s}", this.zzaCI.toDebugString(), this.zzaDd.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaDd.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawDataPoint> zzxu() {
        return this.zzy(this.zzaDe);
    }

    List<RawDataPoint> zzy(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaDd.size());
        for (DataPoint dataPoint : this.zzaDd) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzxv() {
        return this.zzaDe;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }
}

