/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
extends AbstractSafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int mVersionCode;
    private final DataType zzaCH;
    private final String mName;
    private final int zzagd;
    private final Device zzaDf;
    private final Application zzaDg;
    private final String zzaDh;
    private final String zzaDi;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int n, DataType dataType, String string, int n2, Device device, Application application, String string2) {
        this.mVersionCode = n;
        this.zzaCH = dataType;
        this.zzagd = n2;
        this.mName = string;
        this.zzaDf = device;
        this.zzaDg = application;
        this.zzaDh = string2;
        this.zzaDi = this.zzxx();
    }

    private DataSource(Builder builder) {
        this.mVersionCode = 3;
        this.zzaCH = builder.zzaCH;
        this.zzagd = builder.zzagd;
        this.mName = builder.mName;
        this.zzaDf = builder.zzaDf;
        this.zzaDg = builder.zzaDg;
        this.zzaDh = builder.zzaDh;
        this.zzaDi = this.zzxx();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzaCH;
    }

    public int getType() {
        return this.zzagd;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzaDg == null ? null : this.zzaDg.getPackageName();
    }

    public Application zzxw() {
        return this.zzaDg;
    }

    public Device getDevice() {
        return this.zzaDf;
    }

    public String getStreamName() {
        return this.zzaDh;
    }

    public String getStreamIdentifier() {
        return this.zzaDi;
    }

    private String zzxx() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzaCH.getName());
        if (this.zzaDg != null) {
            stringBuilder.append(":").append(this.zzaDg.getPackageName());
        }
        if (this.zzaDf != null) {
            stringBuilder.append(":").append(this.zzaDf.getStreamIdentifier());
        }
        if (this.zzaDh != null) {
            stringBuilder.append(":").append(this.zzaDh);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSource && this.zza((DataSource)((Object)object));
    }

    private boolean zza(DataSource dataSource) {
        return this.zzaDi.equals(dataSource.zzaDi);
    }

    public int hashCode() {
        return this.zzaDi.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzaDg != null) {
            stringBuilder.append(":").append((Object)this.zzaDg);
        }
        if (this.zzaDf != null) {
            stringBuilder.append(":").append((Object)this.zzaDf);
        }
        if (this.zzaDh != null) {
            stringBuilder.append(":").append(this.zzaDh);
        }
        stringBuilder.append(":").append((Object)this.zzaCH);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = this.zzagd == 0 ? "r" : "d";
        String string8 = String.valueOf(this.zzaCH.zzxy());
        if (this.zzaDg == null) {
            string6 = "";
        } else if (this.zzaDg.equals((Object)Application.zzaCO)) {
            string6 = ":gms";
        } else {
            String string9 = String.valueOf(this.zzaDg.getPackageName());
            string6 = string5 = string9.length() != 0 ? ":".concat(string9) : new String(":");
        }
        if (this.zzaDf != null) {
            string4 = String.valueOf(this.zzaDf.getModel());
            string3 = String.valueOf(this.zzaDf.getUid());
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.zzaDh != null) {
            String string10 = String.valueOf(this.zzaDh);
            string = string10.length() != 0 ? ":".concat(string10) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string7).append(":").append(string8).append(string5).append(string4).append(string3).toString();
    }

    private String getTypeString() {
        switch (this.zzagd) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public static final class Builder {
        private DataType zzaCH;
        private int zzagd = -1;
        private String mName;
        private Device zzaDf;
        private Application zzaDg;
        private String zzaDh = "";

        public Builder setDataType(DataType dataType) {
            this.zzaCH = dataType;
            return this;
        }

        public Builder setType(int n) {
            this.zzagd = n;
            return this;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzaDf = device;
            return this;
        }

        public Builder setAppPackageName(String string) {
            this.zzaDg = Application.zzdO(string);
            return this;
        }

        public Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public Builder setStreamName(String string) {
            zzaa.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzaDh = string;
            return this;
        }

        public DataSource build() {
            zzaa.zza((this.zzaCH != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzaa.zza((this.zzagd >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

