/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzrs;

public final class Device
extends AbstractSafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int mVersionCode;
    private final String zzaDw;
    private final String zzaDx;
    private final String zzahE;
    private final String zzaDy;
    private final int zzagd;
    private final int zzaDz;
    public static final Parcelable.Creator<Device> CREATOR = new zzi();

    public static Device getLocalDevice(Context context) {
        int n = zzqo.zzaO(context);
        String string = Device.zzaK(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzaK(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    public Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.mVersionCode = n;
        this.zzaDw = (String)zzaa.zzz((Object)string);
        this.zzaDx = (String)zzaa.zzz((Object)string2);
        this.zzahE = "";
        this.zzaDy = (String)zzaa.zzz((Object)string4);
        this.zzagd = n2;
        this.zzaDz = n3;
    }

    public String getManufacturer() {
        return this.zzaDw;
    }

    public String getModel() {
        return this.zzaDx;
    }

    public String getVersion() {
        return this.zzahE;
    }

    public String getUid() {
        return this.zzaDy;
    }

    public int getType() {
        return this.zzagd;
    }

    public int zzxB() {
        return this.zzaDz;
    }

    private boolean zzxC() {
        return this.zzxB() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaDw, this.zzaDx, this.zzaDy);
    }

    public String zzxD() {
        return this.zzxC() ? this.zzaDy : zzrs.zzeg(this.zzaDy);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzahE, this.zzagd, this.zzaDz);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Device && this.zza((Device)((Object)object));
    }

    private boolean zza(Device device) {
        return zzz.equal((Object)this.zzaDw, (Object)device.zzaDw) && zzz.equal((Object)this.zzaDx, (Object)device.zzaDx) && zzz.equal((Object)this.zzahE, (Object)device.zzahE) && zzz.equal((Object)this.zzaDy, (Object)device.zzaDy) && this.zzagd == device.zzagd && this.zzaDz == device.zzaDz;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaDw, this.zzaDx, this.zzahE, this.zzaDy, this.zzagd});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }
}

