/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzu;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final int zzaDN;
    private boolean zzaEd;
    private float zzaDS;
    private String zzaEe;
    private Map<String, MapValue> zzaEf;
    private int[] zzaEg;
    private float[] zzaEh;
    private byte[] zzaEi;
    public static final Parcelable.Creator<Value> CREATOR = new zzu();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        this.mVersionCode = n;
        this.zzaDN = n2;
        this.zzaEd = bl;
        this.zzaDS = f;
        this.zzaEe = string;
        this.zzaEf = Value.zzx(bundle);
        this.zzaEg = nArray;
        this.zzaEh = fArray;
        this.zzaEi = byArray;
    }

    public void setInt(int n) {
        zzaa.zza((this.zzaDN == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzaEd = true;
        this.zzaDS = Float.intBitsToFloat(n);
    }

    public void setFloat(float f) {
        zzaa.zza((this.zzaDN == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzaEd = true;
        this.zzaDS = f;
    }

    public void setString(String string) {
        zzaa.zza((this.zzaDN == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzaEd = true;
        this.zzaEe = string;
    }

    public void setKeyValue(String string, float f) {
        zzaa.zza((this.zzaDN == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzaEd = true;
        if (this.zzaEf == null) {
            this.zzaEf = new HashMap<String, MapValue>();
        }
        this.zzaEf.put(string, MapValue.zzc(f));
    }

    public void clearKey(String string) {
        zzaa.zza((this.zzaDN == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzaEf != null) {
            this.zzaEf.remove(string);
        }
    }

    public void setActivity(String string) {
        this.setInt(FitnessActivities.zzdN(string));
    }

    public boolean isSet() {
        return this.zzaEd;
    }

    public int getFormat() {
        return this.zzaDN;
    }

    public int asInt() {
        zzaa.zza((this.zzaDN == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzaDS);
    }

    public float asFloat() {
        zzaa.zza((this.zzaDN == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzaDS;
    }

    public String asString() {
        zzaa.zza((this.zzaDN == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzaEe;
    }

    @Nullable
    public Float getKeyValue(String string) {
        zzaa.zza((this.zzaDN == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzaEf != null && this.zzaEf.containsKey(string)) {
            return Float.valueOf(this.zzaEf.get(string).asFloat());
        }
        return null;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Value && this.zza((Value)((Object)object));
    }

    private boolean zza(Value value) {
        if (this.zzaDN == value.zzaDN && this.zzaEd == value.zzaEd) {
            switch (this.zzaDN) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.zzaDS == value.zzaDS;
                }
                case 3: {
                    return zzz.equal((Object)this.zzaEe, (Object)value.zzaEe);
                }
                case 4: {
                    return zzz.equal(this.zzaEf, value.zzaEf);
                }
                case 5: {
                    return Arrays.equals(this.zzaEg, value.zzaEg);
                }
                case 6: {
                    return Arrays.equals(this.zzaEh, value.zzaEh);
                }
                case 7: {
                    return Arrays.equals(this.zzaEi, value.zzaEi);
                }
            }
            return this.zzaDS == value.zzaDS;
        }
        return false;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{Float.valueOf(this.zzaDS), this.zzaEe, this.zzaEf, this.zzaEg, this.zzaEh, this.zzaEi});
    }

    public String toString() {
        if (!this.zzaEd) {
            return "unset";
        }
        switch (this.zzaDN) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.zzaDS);
            }
            case 3: {
                return this.zzaEe;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzaEf).toString();
            }
            case 5: {
                return Arrays.toString(this.zzaEg);
            }
            case 6: {
                return Arrays.toString(this.zzaEh);
            }
            case 7: {
                return zzm.zza((byte[])this.zzaEi, (int)0, (int)this.zzaEi.length, (boolean)false);
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    float zzxF() {
        return this.zzaDS;
    }

    String zzxK() {
        return this.zzaEe;
    }

    Bundle zzxL() {
        if (this.zzaEf == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzaEf.size());
        for (Map.Entry<String, MapValue> entry : this.zzaEf.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzxM() {
        return this.zzaEg;
    }

    float[] zzxN() {
        return this.zzaEh;
    }

    byte[] zzxO() {
        return this.zzaEi;
    }

    private static Map<String, MapValue> zzx(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, (MapValue)bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzu.zza(this, parcel, n);
    }
}

