/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzra;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends AbstractSafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzaCS;
    private final List<DataSource> zzaHs;
    private final long zzXy;
    private final long zzaCJ;
    private final List<DataType> zzaHx;
    private final List<DataSource> zzaHy;
    private final int zzaCV;
    private final long zzaHz;
    private final DataSource zzaHA;
    private final int zzaHB;
    private final boolean zzaHC;
    private final boolean zzaHD;
    private final zzra zzaHE;
    private final List<Device> zzaHF;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5) {
        this.mVersionCode = n;
        this.zzaCS = list;
        this.zzaHs = list2;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaHx = list3;
        this.zzaHy = list4;
        this.zzaCV = n2;
        this.zzaHz = l3;
        this.zzaHA = dataSource;
        this.zzaHB = n3;
        this.zzaHC = bl;
        this.zzaHD = bl2;
        this.zzaHE = iBinder == null ? null : zzra.zza.zzbK(iBinder);
        this.zzaHF = list5 == null ? Collections.emptyList() : list5;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzaCS, builder.zzaHs, builder.zzXy, builder.zzaCJ, builder.zzaHx, builder.zzaHy, builder.zzaCV, builder.zzaHz, builder.zzaHA, builder.zzaHB, Builder.zzk(builder), builder.zzaHD, null, builder.zzaHF);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzra zzra2) {
        this(dataReadRequest.zzaCS, dataReadRequest.zzaHs, dataReadRequest.zzXy, dataReadRequest.zzaCJ, dataReadRequest.zzaHx, dataReadRequest.zzaHy, dataReadRequest.zzaCV, dataReadRequest.zzaHz, dataReadRequest.zzaHA, dataReadRequest.zzaHB, dataReadRequest.zzaHC, dataReadRequest.zzaHD, zzra2, dataReadRequest.zzaHF);
    }

    public DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzra zzra2, List<Device> list5) {
        this(5, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzra2 == null ? null : zzra2.asBinder(), list5);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzaCS;
    }

    public List<DataSource> getDataSources() {
        return this.zzaHs;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaHx;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaHy;
    }

    public int getBucketType() {
        return this.zzaCV;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaHz, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaHA;
    }

    public int getLimit() {
        return this.zzaHB;
    }

    public boolean zzxZ() {
        return this.zzaHD;
    }

    public boolean zzya() {
        return this.zzaHC;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadRequest && this.zzb((DataReadRequest)((Object)object));
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzaCS.equals(dataReadRequest.zzaCS) && this.zzaHs.equals(dataReadRequest.zzaHs) && this.zzXy == dataReadRequest.zzXy && this.zzaCJ == dataReadRequest.zzaCJ && this.zzaCV == dataReadRequest.zzaCV && this.zzaHy.equals(dataReadRequest.zzaHy) && this.zzaHx.equals(dataReadRequest.zzaHx) && zzz.equal((Object)((Object)this.zzaHA), (Object)((Object)dataReadRequest.zzaHA)) && this.zzaHz == dataReadRequest.zzaHz && this.zzaHD == dataReadRequest.zzaHD;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCV, this.zzXy, this.zzaCJ});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzaCS.isEmpty()) {
            for (DataType abstractSafeParcelable : this.zzaCS) {
                stringBuilder.append(abstractSafeParcelable.zzxy()).append(" ");
            }
        }
        if (!this.zzaHs.isEmpty()) {
            for (DataSource dataSource : this.zzaHs) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzaCV != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzfc(this.zzaCV));
            if (this.zzaHz > 0L) {
                stringBuilder.append(" >").append(this.zzaHz).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaHx.isEmpty()) {
            for (DataType dataType : this.zzaHx) {
                stringBuilder.append(dataType.zzxy()).append(" ");
            }
        }
        if (!this.zzaHy.isEmpty()) {
            for (DataSource dataSource : this.zzaHy) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzXy, this.zzXy, this.zzaCJ, this.zzaCJ));
        if (this.zzaHA != null) {
            stringBuilder.append("activities: ").append(this.zzaHA.toDebugString());
        }
        if (this.zzaHD) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public long zzoq() {
        return this.zzXy;
    }

    public long zzyb() {
        return this.zzaHz;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHE == null ? null : this.zzaHE.asBinder();
    }

    public List<Device> zzyc() {
        return this.zzaHF;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public static class Builder {
        private List<DataType> zzaCS = new ArrayList<DataType>();
        private List<DataSource> zzaHs = new ArrayList<DataSource>();
        private List<DataType> zzaHx = new ArrayList<DataType>();
        private List<DataSource> zzaHy = new ArrayList<DataSource>();
        private DataSource zzaHA;
        private long zzXy;
        private long zzaCJ;
        private int zzaCV = 0;
        private long zzaHz = 0L;
        private int zzaHB = 0;
        private boolean zzaHC = false;
        private boolean zzaHD = false;
        private List<Device> zzaHF = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzaa.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzaa.zzb((!this.zzaHy.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaHs.contains((Object)dataSource)) {
                this.zzaHs.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzaa.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzaa.zza((!this.zzaHx.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzaCS.contains((Object)dataType)) {
                this.zzaCS.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzaa.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzaa.zza((!this.zzaHs.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            zzaa.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains((Object)dataType2), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzaa.zzb((boolean)DataType.getAggregatesForInput(dataType2).contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzaHy.contains((Object)dataSource)) {
                this.zzaHy.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzaa.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzaa.zza((!this.zzaCS.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzaa.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains((Object)dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzaa.zzb((boolean)DataType.getAggregatesForInput(dataType).contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzaHx.contains((Object)dataType)) {
                this.zzaHx.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaCV = 1;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaCV = 3;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzaa.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzaa.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaHA = dataSource;
            this.zzaCV = 3;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaCV = 4;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzaa.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzaa.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaHA = dataSource;
            this.zzaCV = 4;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzaa.zzb((this.zzaCV == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaCV});
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaCV = 2;
            this.zzaHz = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzXy = timeUnit.toMillis(l);
            this.zzaCJ = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaHD = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzaHB = n;
            return this;
        }

        public DataReadRequest build() {
            zzaa.zza((!this.zzaHs.isEmpty() || !this.zzaCS.isEmpty() || !this.zzaHy.isEmpty() || !this.zzaHx.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzaa.zza((this.zzXy > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzXy});
            zzaa.zza((this.zzaCJ > 0L && this.zzaCJ > this.zzXy ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaCJ});
            boolean bl = this.zzaHy.isEmpty() && this.zzaHx.isEmpty();
            zzaa.zza((bl && this.zzaCV == 0 || !bl && this.zzaCV != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }

        static /* synthetic */ boolean zzk(Builder builder) {
            return false;
        }
    }
}

