/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.internal.ClientIdentity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private DataSource zzaCI;
    private DataType zzaCH;
    private zzk zzaHU;
    int zzaHV;
    int zzaHW;
    private final long zzaEb;
    private final long zzaHX;
    private final PendingIntent mPendingIntent;
    private final long zzaHY;
    private final int zzaEc;
    private final List<LocationRequest> zzaHZ;
    private final long zzaIa;
    private final List<ClientIdentity> zzaIb;
    private final zzrp zzaHq;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzv();

    SensorRegistrationRequest(int n, DataSource dataSource, DataType dataType, IBinder iBinder, int n2, int n3, long l, long l2, PendingIntent pendingIntent, long l3, int n4, List<LocationRequest> list, long l4, IBinder iBinder2) {
        this.mVersionCode = n;
        this.zzaCI = dataSource;
        this.zzaCH = dataType;
        this.zzaHU = iBinder == null ? null : zzk.zza.zzbB(iBinder);
        this.zzaEb = l == 0L ? (long)n2 : l;
        this.zzaHY = l3;
        this.zzaHX = l2 == 0L ? (long)n3 : l2;
        this.zzaHZ = list;
        this.mPendingIntent = pendingIntent;
        this.zzaEc = n4;
        this.zzaIb = Collections.emptyList();
        this.zzaIa = l4;
        this.zzaHq = zzrp.zza.zzbZ(iBinder2);
    }

    public SensorRegistrationRequest(SensorRequest sensorRequest, zzk zzk2, PendingIntent pendingIntent, zzrp zzrp2) {
        this(sensorRequest.getDataSource(), sensorRequest.getDataType(), zzk2, pendingIntent, sensorRequest.getSamplingRate(TimeUnit.MICROSECONDS), sensorRequest.getFastestRate(TimeUnit.MICROSECONDS), sensorRequest.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), sensorRequest.getAccuracyMode(), null, Collections.emptyList(), sensorRequest.zzym(), zzrp2);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzk zzk2, PendingIntent pendingIntent, long l, long l2, long l3, int n, List<LocationRequest> list, List<ClientIdentity> list2, long l4, zzrp zzrp2) {
        this.mVersionCode = 6;
        this.zzaCI = dataSource;
        this.zzaCH = dataType;
        this.zzaHU = zzk2;
        this.mPendingIntent = pendingIntent;
        this.zzaEb = l;
        this.zzaHY = l2;
        this.zzaHX = l3;
        this.zzaEc = n;
        this.zzaHZ = list;
        this.zzaIb = list2;
        this.zzaIa = l4;
        this.zzaHq = zzrp2;
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public DataType getDataType() {
        return this.zzaCH;
    }

    public PendingIntent getIntent() {
        return this.mPendingIntent;
    }

    public long zzyh() {
        return this.zzaHY;
    }

    public long zzxH() {
        return this.zzaEb;
    }

    public long zzyi() {
        return this.zzaHX;
    }

    public List<LocationRequest> zzyj() {
        return this.zzaHZ;
    }

    public int getAccuracyMode() {
        return this.zzaEc;
    }

    public long zzyk() {
        return this.zzaIa;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHq == null ? null : this.zzaHq.asBinder();
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", new Object[]{this.zzaCH, this.zzaCI, this.zzaEb, this.zzaHY, this.zzaHX});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzyl() {
        return this.zzaHU == null ? null : this.zzaHU.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzv.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)((Object)object));
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)sensorRegistrationRequest.zzaCI)) && zzz.equal((Object)((Object)this.zzaCH), (Object)((Object)sensorRegistrationRequest.zzaCH)) && this.zzaEb == sensorRegistrationRequest.zzaEb && this.zzaHY == sensorRegistrationRequest.zzaHY && this.zzaHX == sensorRegistrationRequest.zzaHX && this.zzaEc == sensorRegistrationRequest.zzaEc && zzz.equal(this.zzaHZ, sensorRegistrationRequest.zzaHZ);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCI, this.zzaCH, this.zzaHU, this.zzaEb, this.zzaHY, this.zzaHX, this.zzaEc, this.zzaHZ});
    }
}

