/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
extends AbstractSafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource zzaCI;
    private final zzk zzaHU;
    private final long zzaIE;
    private final long zzaIF;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int n, DataSource dataSource, IBinder iBinder, long l, long l2) {
        this.mVersionCode = n;
        this.zzaCI = dataSource;
        this.zzaHU = zzk.zza.zzbB(iBinder);
        this.zzaIE = l;
        this.zzaIF = l2;
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzaHU);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzaIE == -1L ? -1L : timeUnit.convert(this.zzaIE, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaIF, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", new Object[]{this.zzaCI});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzyl() {
        return this.zzaHU.asBinder();
    }

    public long zzxH() {
        return this.zzaIE;
    }

    public long zzyC() {
        return this.zzaIF;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)((Object)object));
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)fitnessSensorServiceRequest.zzaCI)) && this.zzaIE == fitnessSensorServiceRequest.zzaIE && this.zzaIF == fitnessSensorServiceRequest.zzaIF;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCI, this.zzaIE, this.zzaIF});
    }
}

