/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzalR;
    private final String zzaiX;
    private final String zzaWT;
    private final String zzaWU;
    private final String zzacd;
    private final String zzaWV;
    private final Uri zzaWW;
    private final Uri zzaWX;
    private final Uri zzaWY;
    private final boolean zzaWZ;
    private final boolean zzaXa;
    private final String zzaXb;
    private final int zzaXc;
    private final int zzaXd;
    private final int zzaXe;
    private final boolean zzaXf;
    private final boolean zzaXg;
    private final String zzaXh;
    private final String zzaXi;
    private final String zzaXj;
    private final boolean zzOD;
    private final boolean zzaXk;
    private final boolean zzaXl;
    private final String zzaXm;
    private final boolean zzaXn;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzalR = game.getApplicationId();
        this.zzaWT = game.getPrimaryCategory();
        this.zzaWU = game.getSecondaryCategory();
        this.zzacd = game.getDescription();
        this.zzaWV = game.getDeveloperName();
        this.zzaiX = game.getDisplayName();
        this.zzaWW = game.getIconImageUri();
        this.zzaXh = game.getIconImageUrl();
        this.zzaWX = game.getHiResImageUri();
        this.zzaXi = game.getHiResImageUrl();
        this.zzaWY = game.getFeaturedImageUri();
        this.zzaXj = game.getFeaturedImageUrl();
        this.zzaWZ = game.zzCV();
        this.zzaXa = game.zzCX();
        this.zzaXb = game.zzCY();
        this.zzaXc = 1;
        this.zzaXd = game.getAchievementTotalCount();
        this.zzaXe = game.getLeaderboardCount();
        this.zzaXf = game.isRealTimeMultiplayerEnabled();
        this.zzaXg = game.isTurnBasedMultiplayerEnabled();
        this.zzOD = game.isMuted();
        this.zzaXk = game.zzCW();
        this.zzaXl = game.areSnapshotsEnabled();
        this.zzaXm = game.getThemeColor();
        this.zzaXn = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.zzalR = string;
        this.zzaiX = string2;
        this.zzaWT = string3;
        this.zzaWU = string4;
        this.zzacd = string5;
        this.zzaWV = string6;
        this.zzaWW = uri;
        this.zzaXh = string8;
        this.zzaWX = uri2;
        this.zzaXi = string9;
        this.zzaWY = uri3;
        this.zzaXj = string10;
        this.zzaWZ = bl;
        this.zzaXa = bl2;
        this.zzaXb = string7;
        this.zzaXc = n2;
        this.zzaXd = n3;
        this.zzaXe = n4;
        this.zzaXf = bl3;
        this.zzaXg = bl4;
        this.zzOD = bl5;
        this.zzaXk = bl6;
        this.zzaXl = bl7;
        this.zzaXm = string11;
        this.zzaXn = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzalR;
    }

    @Override
    public String getDisplayName() {
        return this.zzaiX;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaiX, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzaWT;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaWU;
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.zzaWV;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaWV, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaWW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXh;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaWX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaXi;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaWY;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzaXj;
    }

    @Override
    public boolean isMuted() {
        return this.zzOD;
    }

    @Override
    public boolean zzCW() {
        return this.zzaXk;
    }

    @Override
    public boolean zzCV() {
        return this.zzaWZ;
    }

    @Override
    public boolean zzCX() {
        return this.zzaXa;
    }

    @Override
    public String zzCY() {
        return this.zzaXb;
    }

    public int zzCZ() {
        return this.zzaXc;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzaXd;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzaXe;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzaXf;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzaXg;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzaXl;
    }

    @Override
    public String getThemeColor() {
        return this.zzaXm;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzaXn;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzaa.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzCV(), game.zzCX(), game.zzCY(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzCW(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzaa.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzaa.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzaa.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzaa.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzaa.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzaa.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzaa.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzaa.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzaa.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzaa.equal((Object)game2.zzCV(), (Object)game.zzCV()) && zzaa.equal((Object)game2.zzCX(), (Object)game.zzCX()) && zzaa.equal((Object)game2.zzCY(), (Object)game.zzCY()) && zzaa.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzaa.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzaa.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzaa.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzaa.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzaa.equal((Object)game2.zzCW(), (Object)game.zzCW()) ? 1 : 0)) && zzaa.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzaa.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzaa.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzaa.zzv((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzCV()).zzg("InstanceInstalled", (Object)game.zzCX()).zzg("InstancePackageName", (Object)game.zzCY()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameEntityCreator.zza(this, parcel, n);
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzfr(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzxo());
            if (bl || GameEntity.zzdp((String)GameEntity.class.getCanonicalName())) {
                return super.zzfr(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfr(parcel);
        }
    }
}

