/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.SocialImpl;
import com.google.android.gms.games.internal.api.StatsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.api.VideosImpl;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> zzahc = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzahd = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(SCOPE_GAMES);
        }

        public /* synthetic */ List zzp(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    private static final Api.zza<GamesClientImpl, GamesOptions> zzaXo = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(zzaXp);
        }

        public /* synthetic */ List zzp(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api("Games.API", zzahd, zzahc);
    public static final Scope zzaXp = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> zzaXq = new Api("Games.API_1P", zzaXo, zzahc);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents zzaXr = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer zzaXs = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Stats Stats = new StatsImpl();
    public static final Videos Videos = new VideosImpl();
    public static final Social zzaXt = new SocialImpl();

    private Games() {
    }

    public static GamesClientImpl zzi(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzac.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(zzahc) : null;
    }

    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zziy(n);
        }
    }

    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzac.zzw((Object)view);
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzv(view);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzEb();
    }

    @Deprecated
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, final String string) {
        zzac.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zzb((zzzv.zza)new GetServerAuthCodeImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(string, (zzzv.zzb<GetServerAuthCodeResult>)this);
            }
        });
    }

    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzjI();
    }

    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzEn();
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new SignOutImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zzzv.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzEo();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class GetServerAuthCodeImpl
    extends BaseGamesApiMethodImpl<GetServerAuthCodeResult> {
        private GetServerAuthCodeImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public GetServerAuthCodeResult zzaj(final Status status) {
            return new GetServerAuthCodeResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getCode() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaj(status);
        }
    }

    private static abstract class GetTokenImpl
    extends BaseGamesApiMethodImpl<GetTokenResult> {
        public GetTokenResult zzak(final Status status) {
            return new GetTokenResult(this){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzak(status);
        }
    }

    @Deprecated
    public static interface GetServerAuthCodeResult
    extends Result {
        public String getCode();
    }

    public static interface GetTokenResult
    extends Result {
    }

    public static abstract class StatusImpl
    extends BaseGamesApiMethodImpl<Status> {
        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zzzv.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(zzahc, googleApiClient);
        }
    }

    private static abstract class GamesClientBuilder
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private GamesClientBuilder() {
        }

        public GamesClientImpl zza(Context context, Looper looper, zzg zzg2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzg2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean zzaXv;
        public final boolean zzaXw;
        public final int zzaXx;
        public final boolean zzaXy;
        public final int zzaXz;
        public final String zzaXA;
        public final ArrayList<String> zzaXB;
        public final boolean zzaXC;
        public final boolean zzaXD;

        private GamesOptions() {
            this.zzaXv = false;
            this.zzaXw = true;
            this.zzaXx = 17;
            this.zzaXy = false;
            this.zzaXz = 4368;
            this.zzaXA = null;
            this.zzaXB = new ArrayList();
            this.zzaXC = false;
            this.zzaXD = false;
        }

        private GamesOptions(Builder builder) {
            this.zzaXv = false;
            this.zzaXw = builder.zzaXw;
            this.zzaXx = builder.zzaXx;
            this.zzaXy = false;
            this.zzaXz = builder.zzaXz;
            this.zzaXA = null;
            this.zzaXB = builder.zzaXB;
            this.zzaXC = builder.zzaXC;
            this.zzaXD = false;
        }

        public Bundle zzDb() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", false);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzaXw);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzaXx);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", false);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzaXz);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", null);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzaXB);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzaXC);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", false);
            return bundle;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean zzaXv = false;
            boolean zzaXw = true;
            int zzaXx = 17;
            boolean zzaXy = false;
            int zzaXz = 4368;
            String zzaXA = null;
            ArrayList<String> zzaXB = new ArrayList();
            boolean zzaXC = false;
            boolean zzaXD = false;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean bl) {
                this.zzaXw = bl;
                this.zzaXx = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean bl, int n) {
                this.zzaXw = bl;
                this.zzaXx = n;
                return this;
            }

            @Deprecated
            public Builder setRequireGooglePlus(boolean bl) {
                this.zzaXC = bl;
                return this;
            }

            public Builder setSdkVariant(int n) {
                this.zzaXz = n;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

