/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String zzaus;
    private String zzaiX;
    private final Uri zzaWW;
    private final Uri zzaWX;
    private final long zzaXE;
    private final int zzaXF;
    private final long zzaXG;
    private final String zzaXh;
    private final String zzaXi;
    private final String zzalD;
    private final MostRecentGameInfoEntity zzaXH;
    private final PlayerLevelInfo zzaXI;
    private final boolean zzaXJ;
    private final boolean zzaXK;
    private final String zzaXL;
    private final String mName;
    private final Uri zzaXM;
    private final String zzaXN;
    private final Uri zzaXO;
    private final String zzaXP;
    private final int zzaXQ;
    private final long zzaXR;
    private final boolean zzZA;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.zzaus = bl ? player.getPlayerId() : null;
        this.zzaiX = player.getDisplayName();
        this.zzaWW = player.getIconImageUri();
        this.zzaXh = player.getIconImageUrl();
        this.zzaWX = player.getHiResImageUri();
        this.zzaXi = player.getHiResImageUrl();
        this.zzaXE = player.getRetrievedTimestamp();
        this.zzaXF = player.zzDe();
        this.zzaXG = player.getLastPlayedWithTimestamp();
        this.zzalD = player.getTitle();
        this.zzaXJ = player.zzDf();
        MostRecentGameInfo mostRecentGameInfo = player.zzDg();
        this.zzaXH = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaXI = player.getLevelInfo();
        this.zzaXK = player.zzDd();
        this.zzaXL = player.zzDc();
        this.mName = player.getName();
        this.zzaXM = player.getBannerImageLandscapeUri();
        this.zzaXN = player.getBannerImageLandscapeUrl();
        this.zzaXO = player.getBannerImagePortraitUri();
        this.zzaXP = player.getBannerImagePortraitUrl();
        this.zzaXQ = player.zzDh();
        this.zzaXR = player.zzDi();
        this.zzZA = player.isMuted();
        if (bl) {
            zzc.zzt((Object)this.zzaus);
        }
        zzc.zzt((Object)this.zzaiX);
        zzc.zzar((this.zzaXE > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.zzaus = string;
        this.zzaiX = string2;
        this.zzaWW = uri;
        this.zzaXh = string3;
        this.zzaWX = uri2;
        this.zzaXi = string4;
        this.zzaXE = l;
        this.zzaXF = n2;
        this.zzaXG = l2;
        this.zzalD = string5;
        this.zzaXJ = bl;
        this.zzaXH = mostRecentGameInfoEntity;
        this.zzaXI = playerLevelInfo;
        this.zzaXK = bl2;
        this.zzaXL = string6;
        this.mName = string7;
        this.zzaXM = uri3;
        this.zzaXN = string8;
        this.zzaXO = uri4;
        this.zzaXP = string9;
        this.zzaXQ = n3;
        this.zzaXR = l3;
        this.zzZA = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzaus;
    }

    @Override
    public String getDisplayName() {
        return this.zzaiX;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaiX, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzDc() {
        return this.zzaXL;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzDd() {
        return this.zzaXK;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaWW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXh;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaWX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaXi;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzaXE;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaXG;
    }

    @Override
    public int zzDe() {
        return this.zzaXF;
    }

    @Override
    public boolean zzDf() {
        return this.zzaXJ;
    }

    @Override
    public String getTitle() {
        return this.zzalD;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzalD, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaXI;
    }

    @Override
    public MostRecentGameInfo zzDg() {
        return this.zzaXH;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzaXM;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.zzaXN;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzaXO;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.zzaXP;
    }

    @Override
    public int zzDh() {
        return this.zzaXQ;
    }

    @Override
    public long zzDi() {
        return this.zzaXR;
    }

    @Override
    public boolean isMuted() {
        return this.zzZA;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return zzaa.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzDd(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzDc(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzDh(), player.zzDi(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzaa.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzaa.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzaa.equal((Object)player2.zzDd(), (Object)player.zzDd()) && zzaa.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzaa.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzaa.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzaa.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzaa.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzaa.equal((Object)player2.zzDc(), (Object)player.zzDc()) && zzaa.equal((Object)player2.getName(), (Object)player.getName()) && zzaa.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzaa.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzaa.equal((Object)player2.zzDh(), (Object)player.zzDh()) && zzaa.equal((Object)player2.zzDi(), (Object)player.zzDi()) && zzaa.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzaa.zzv((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzDd()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzDc()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzDh()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzDi()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntityCreator.zza(this, parcel, n);
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzfs(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzxo());
            if (bl || PlayerEntity.zzdp((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzfs(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfs(parcel);
        }
    }
}

