/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzaXZ;
    private final PlayerLevelInfo zzaXI;
    private final MostRecentGameInfoRef zzaYa;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.zzaXZ = new PlayerColumnNames(string);
        this.zzaYa = new MostRecentGameInfoRef(dataHolder, n, this.zzaXZ);
        if (this.zzDj()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.zzaXZ.zzbcp);
            int n3 = this.getInteger(this.zzaXZ.zzbcs);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.zzaXZ.zzbcq), this.getLong(this.zzaXZ.zzbcr));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.zzaXZ.zzbcr), this.getLong(this.zzaXZ.zzbct));
            }
            this.zzaXI = new PlayerLevelInfo(this.getLong(this.zzaXZ.zzbco), this.getLong(this.zzaXZ.zzbcu), playerLevel, playerLevel2);
        } else {
            this.zzaXI = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzaXZ.zzbcf);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzaXZ.zzbcg);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaXZ.zzbcg, charArrayBuffer);
    }

    @Override
    public String zzDc() {
        return this.getString(this.zzaXZ.zzbcE);
    }

    @Override
    public String getName() {
        return this.getString(this.zzaXZ.name);
    }

    @Override
    public boolean zzDd() {
        return this.getBoolean(this.zzaXZ.zzbcD);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzdk(this.zzaXZ.zzbch);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzaXZ.zzbci);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzdk(this.zzaXZ.zzbcj);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzaXZ.zzbck);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzaXZ.zzbcl);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzdj(this.zzaXZ.zzbcn) || this.zzdl(this.zzaXZ.zzbcn)) {
            return -1L;
        }
        return this.getLong(this.zzaXZ.zzbcn);
    }

    @Override
    public int zzDe() {
        return this.getInteger(this.zzaXZ.zzbcm);
    }

    @Override
    public boolean zzDf() {
        return this.getBoolean(this.zzaXZ.zzbcw);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzaXZ.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaXZ.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaXI;
    }

    @Override
    public MostRecentGameInfo zzDg() {
        if (this.zzdl(this.zzaXZ.zzbcx)) {
            return null;
        }
        return this.zzaYa;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzdk(this.zzaXZ.zzbcF);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zzaXZ.zzbcG);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzdk(this.zzaXZ.zzbcH);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zzaXZ.zzbcI);
    }

    @Override
    public int zzDh() {
        return this.getInteger(this.zzaXZ.zzbcJ);
    }

    @Override
    public long zzDi() {
        return this.getLong(this.zzaXZ.zzbcK);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.zzaXZ.zzbcL);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zza(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzDj() {
        if (this.zzdl(this.zzaXZ.zzbco)) {
            return false;
        }
        return this.getLong(this.zzaXZ.zzbco) != -1L;
    }
}

