/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;

public final class AchievementEntity
extends GamesAbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzaYb;
    private final int zzanR;
    private final String mName;
    private final String zzacd;
    private final Uri zzaYc;
    private final String zzaYd;
    private final Uri zzaYe;
    private final String zzaYf;
    private final int zzaYg;
    private final String zzaYh;
    private final PlayerEntity zzaYi;
    private final int mState;
    private final int zzaYj;
    private final String zzaYk;
    private final long zzaYl;
    private final long zzaYm;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzaYb = achievement.getAchievementId();
        this.zzanR = achievement.getType();
        this.mName = achievement.getName();
        this.zzacd = achievement.getDescription();
        this.zzaYc = achievement.getUnlockedImageUri();
        this.zzaYd = achievement.getUnlockedImageUrl();
        this.zzaYe = achievement.getRevealedImageUri();
        this.zzaYf = achievement.getRevealedImageUrl();
        this.zzaYi = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaYl = achievement.getLastUpdatedTimestamp();
        this.zzaYm = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaYg = achievement.getTotalSteps();
            this.zzaYh = achievement.getFormattedTotalSteps();
            this.zzaYj = achievement.getCurrentSteps();
            this.zzaYk = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaYg = 0;
            this.zzaYh = null;
            this.zzaYj = 0;
            this.zzaYk = null;
        }
        zzc.zzt((Object)this.zzaYb);
        zzc.zzt((Object)this.zzacd);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.zzaYb = string;
        this.zzanR = n2;
        this.mName = string2;
        this.zzacd = string3;
        this.zzaYc = uri;
        this.zzaYd = string4;
        this.zzaYe = uri2;
        this.zzaYf = string5;
        this.zzaYg = n3;
        this.zzaYh = string6;
        this.zzaYi = playerEntity;
        this.mState = n4;
        this.zzaYj = n5;
        this.zzaYk = string7;
        this.zzaYl = l;
        this.zzaYm = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzaYb;
    }

    @Override
    public int getType() {
        return this.zzanR;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaYc;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaYd;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaYe;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaYf;
    }

    public int zzDp() {
        return this.zzaYg;
    }

    @Override
    public int getTotalSteps() {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzDp();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzDq();
    }

    public String zzDq() {
        return this.zzaYh;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzaYh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.zzaYi;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzDr();
    }

    public int zzDr() {
        return this.zzaYj;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzDs();
    }

    public String zzDs() {
        return this.zzaYk;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzaYk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYl;
    }

    @Override
    public long getXpValue() {
        return this.zzaYm;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzaa.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzaa.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzaa.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzaa.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzaa.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzaa.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzaa.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzaa.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzaa.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzaa.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzaa.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzaa.zza zza2 = zzaa.zzv((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

