/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntity;

public final class AchievementRef
extends zzc
implements Achievement {
    AchievementRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
    }

    @Override
    public String getAchievementId() {
        return this.getString("external_achievement_id");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        this.zza("name", charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzdk("unlocked_icon_image_uri");
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.getString("unlocked_icon_image_url");
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzdk("revealed_icon_image_uri");
    }

    @Override
    public String getRevealedImageUrl() {
        return this.getString("revealed_icon_image_url");
    }

    @Override
    public int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.getInteger("total_steps");
    }

    @Override
    public String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.getString("formatted_total_steps");
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        this.zza("formatted_total_steps", charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return new PlayerRef(this.zzazI, this.zzaCm);
    }

    @Override
    public int getState() {
        return this.getInteger("state");
    }

    @Override
    public int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.getInteger("current_steps");
    }

    @Override
    public String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        return this.getString("formatted_current_steps");
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzar((this.getType() == 1 ? 1 : 0) != 0);
        this.zza("formatted_current_steps", charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public long getXpValue() {
        if (!this.zzdj("instance_xp_value") || this.zzdl("instance_xp_value")) {
            return this.getLong("definition_xp_value");
        }
        return this.getLong("instance_xp_value");
    }

    public Achievement freeze() {
        return new AchievementEntity(this);
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntity achievementEntity = (AchievementEntity)((Achievement)this.freeze());
        achievementEntity.writeToParcel(parcel, n);
    }
}

