/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;

public final class EventEntity
extends GamesAbstractSafeParcelable
implements Event {
    public static final Parcelable.Creator<EventEntity> CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzaYL;
    private final String mName;
    private final String zzacd;
    private final Uri zzaWW;
    private final String zzaXh;
    private final PlayerEntity zzaYi;
    private final long zzacc;
    private final String zzaYM;
    private final boolean zzwn;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzaYL = event.getEventId();
        this.mName = event.getName();
        this.zzacd = event.getDescription();
        this.zzaWW = event.getIconImageUri();
        this.zzaXh = event.getIconImageUrl();
        this.zzaYi = (PlayerEntity)event.getPlayer().freeze();
        this.zzacc = event.getValue();
        this.zzaYM = event.getFormattedValue();
        this.zzwn = event.isVisible();
    }

    EventEntity(int n, String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.mVersionCode = n;
        this.zzaYL = string;
        this.mName = string2;
        this.zzacd = string3;
        this.zzaWW = uri;
        this.zzaXh = string4;
        this.zzaYi = new PlayerEntity(player);
        this.zzacc = l;
        this.zzaYM = string5;
        this.zzwn = bl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaYL;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaWW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXh;
    }

    @Override
    public Player getPlayer() {
        return this.zzaYi;
    }

    @Override
    public long getValue() {
        return this.zzacc;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaYM;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaYM, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zzwn;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzaa.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzaa.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzaa.equal((Object)event2.getName(), (Object)event.getName()) && zzaa.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzaa.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzaa.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzaa.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzaa.equal((Object)event2.getValue(), (Object)event.getValue()) && zzaa.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzaa.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzaa.zzv((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

