/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzbaG;
    protected PopupLocationInfo zzbaH;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzs.zzyy()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int n) {
        this.zzbaG = gamesClientImpl;
        this.zziB(n);
    }

    protected void zziB(int n) {
        this.zzbaH = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int n) {
        this.zzbaH.gravity = n;
    }

    public void zzw(View view) {
    }

    public void zzEN() {
        this.zzbaG.zza(this.zzbaH.zzbaI, this.zzbaH.zzEM());
    }

    public Bundle zzEO() {
        return this.zzbaH.zzEM();
    }

    public IBinder zzEP() {
        return this.zzbaH.zzbaI;
    }

    public PopupLocationInfo zzEQ() {
        return this.zzbaH;
    }

    public static final class PopupLocationInfo {
        public IBinder zzbaI;
        public int gravity;
        public int zzbaJ = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int n, IBinder iBinder) {
            this.gravity = n;
            this.zzbaI = iBinder;
        }

        public Bundle zzEM() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzbaJ);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    @TargetApi(value=12)
    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzbaK;
        private boolean zzaYU = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int n) {
            super(gamesClientImpl, n);
        }

        @Override
        protected void zziB(int n) {
            this.zzbaH = new PopupLocationInfo(n, null);
        }

        @Override
        @TargetApi(value=16)
        public void zzw(View view) {
            Context context;
            View view2;
            this.zzbaG.zzEy();
            if (this.zzbaK != null) {
                view2 = (View)this.zzbaK.get();
                context = this.zzbaG.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzs.zzyC()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzbaK = null;
            view2 = this.zzbaG.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzE("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzx(view);
                this.zzbaK = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzF("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzEN() {
            if (this.zzbaH.zzbaI != null) {
                super.zzEN();
                return;
            }
            this.zzaYU = this.zzbaK != null;
        }

        public void onViewAttachedToWindow(View view) {
            this.zzx(view);
        }

        public void onViewDetachedFromWindow(View view) {
            this.zzbaG.zzEy();
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzbaK == null) {
                return;
            }
            View view = (View)this.zzbaK.get();
            if (view == null) {
                return;
            }
            this.zzx(view);
        }

        @TargetApi(value=17)
        private void zzx(View view) {
            Display display;
            int n = -1;
            if (zzs.zzyD()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzbaH.zzbaJ = n;
            this.zzbaH.zzbaI = display;
            this.zzbaH.left = nArray[0];
            this.zzbaH.top = nArray[1];
            this.zzbaH.right = nArray[0] + n2;
            this.zzbaH.bottom = nArray[1] + n3;
            if (this.zzaYU) {
                this.zzEN();
                this.zzaYU = false;
            }
        }
    }
}

