/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final Parcelable.Creator<GameBadgeEntity> CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzanR;
    private String zzalD;
    private String zzacd;
    private Uri zzaWW;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzanR = gameBadge.getType();
        this.zzalD = gameBadge.getTitle();
        this.zzacd = gameBadge.getDescription();
        this.zzaWW = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int n, int n2, String string, String string2, Uri uri) {
        this.mVersionCode = n;
        this.zzanR = n2;
        this.zzalD = string;
        this.zzacd = string2;
        this.zzaWW = uri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzanR;
    }

    @Override
    public String getTitle() {
        return this.zzalD;
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaWW;
    }

    public GameBadge zzFa() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzaa.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object object) {
        return GameBadgeEntity.zza(this, object);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzaa.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzaa.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzaa.zzv((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameBadgeEntityCreator.zza(this, parcel, n);
    }

    public /* synthetic */ Object freeze() {
        return this.zzFa();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzfG(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzf(GameBadgeEntity.zzxo());
            if (bl || GameBadgeEntity.zzdp((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzfG(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfG(parcel);
        }
    }
}

