/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends GamesAbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final Parcelable.Creator<ProfileSettingsEntity> CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status zzahq;
    private final String zzaXL;
    private final boolean zzbcM;
    private final boolean zzaXJ;
    private final boolean zzbcN;
    private final StockProfileImageEntity zzbcO;
    private final boolean zzbcP;
    private final boolean zzbcQ;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.zzahq = new Status(dataHolder.getStatusCode());
        if (this.zzahq.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzcC(0);
            this.zzaXL = dataHolder.zzd("gamer_tag", 0, n);
            this.zzbcM = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.zzaXJ = dataHolder.zze("profile_visible", 0, n);
            this.zzbcN = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.zzbcO = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.zzbcP = dataHolder.zze("profile_discoverable", 0, n);
            this.zzbcQ = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.zzaXL = null;
            this.zzbcM = false;
            this.zzaXJ = false;
            this.zzbcN = false;
            this.zzbcO = null;
            this.zzbcP = false;
            this.zzbcQ = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.zzahq = status;
        this.zzaXL = string;
        this.zzbcM = bl;
        this.zzaXJ = bl2;
        this.zzbcN = bl3;
        this.zzbcO = stockProfileImageEntity;
        this.zzbcP = bl4;
        this.zzbcQ = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzDc() {
        return this.zzaXL;
    }

    @Override
    public boolean zzDm() {
        return this.zzbcM;
    }

    @Override
    public boolean zzDf() {
        return this.zzaXJ;
    }

    @Override
    public boolean zzDk() {
        return this.zzbcN;
    }

    @Override
    public StockProfileImage zzDl() {
        return this.zzbcO;
    }

    @Override
    public boolean zzDn() {
        return this.zzbcP;
    }

    @Override
    public boolean zzDo() {
        return this.zzbcQ;
    }

    public Status getStatus() {
        return this.zzahq;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaXL, this.zzbcM, this.zzaXJ, this.zzbcN, this.zzahq, this.zzbcO, this.zzbcP, this.zzbcQ});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzaa.equal((Object)this.zzaXL, (Object)loadProfileSettingsResult.zzDc()) && zzaa.equal((Object)this.zzbcM, (Object)loadProfileSettingsResult.zzDm()) && zzaa.equal((Object)this.zzaXJ, (Object)loadProfileSettingsResult.zzDf()) && zzaa.equal((Object)this.zzbcN, (Object)loadProfileSettingsResult.zzDk()) && zzaa.equal((Object)this.zzahq, (Object)loadProfileSettingsResult.getStatus()) && zzaa.equal((Object)this.zzbcO, (Object)loadProfileSettingsResult.zzDl()) && zzaa.equal((Object)this.zzbcP, (Object)loadProfileSettingsResult.zzDn()) && zzaa.equal((Object)this.zzbcQ, (Object)loadProfileSettingsResult.zzDo());
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("GamerTag", (Object)this.zzaXL).zzg("IsGamerTagExplicitlySet", (Object)this.zzbcM).zzg("IsProfileVisible", (Object)this.zzaXJ).zzg("IsVisibilityExplicitlySet", (Object)this.zzbcN).zzg("Status", (Object)this.zzahq).zzg("StockProfileImage", (Object)this.zzbcO).zzg("IsProfileDiscoverable", (Object)this.zzbcP).zzg("AutoSignIn", (Object)this.zzbcQ).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

