/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity zzbbQ;
    private final String zzahi;
    private final long zzbdA;
    private final int zzbdB;
    private final ParticipantEntity zzbdC;
    private final ArrayList<ParticipantEntity> zzbdD;
    private final int zzbdE;
    private final int zzbdF;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.zzbbQ = new GameEntity(invitation.getGame());
        this.zzahi = invitation.getInvitationId();
        this.zzbdA = invitation.getCreationTimestamp();
        this.zzbdB = invitation.getInvitationType();
        this.zzbdE = invitation.getVariant();
        this.zzbdF = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzbdD = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzbdD.add((ParticipantEntity)participant2.freeze());
        }
        zzac.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzbdC = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.zzbbQ = gameEntity;
        this.zzahi = string;
        this.zzbdA = l;
        this.zzbdB = n2;
        this.zzbdC = participantEntity;
        this.zzbdD = arrayList;
        this.zzbdE = n3;
        this.zzbdF = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzbbQ;
    }

    @Override
    public String getInvitationId() {
        return this.zzahi;
    }

    @Override
    public Participant getInviter() {
        return this.zzbdC;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzbdA;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbdD);
    }

    @Override
    public int getInvitationType() {
        return this.zzbdB;
    }

    @Override
    public int getVariant() {
        return this.zzbdE;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzbdF;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzaa.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzaa.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzaa.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzaa.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzaa.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzaa.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzaa.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzaa.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzaa.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzaa.zzv((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        InvitationEntityCreator.zza(this, parcel, n);
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzfN(Parcel parcel) {
            boolean bl = InvitationEntity.zzf(InvitationEntity.zzxo());
            if (bl || InvitationEntity.zzdp((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzfN(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(2, gameEntity, string, l, n, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfN(parcel);
        }
    }
}

