/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaZX;
    private final String zzaiX;
    private final Uri zzaWW;
    private final Uri zzaWX;
    private final int zzJh;
    private final String zzaYN;
    private final boolean zzbdH;
    private final PlayerEntity zzaYi;
    private final int zzamo;
    private final ParticipantResult zzbdI;
    private final String zzaXh;
    private final String zzaXi;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzaZX = participant.getParticipantId();
        this.zzaiX = participant.getDisplayName();
        this.zzaWW = participant.getIconImageUri();
        this.zzaWX = participant.getHiResImageUri();
        this.zzJh = participant.getStatus();
        this.zzaYN = participant.zzDY();
        this.zzbdH = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaYi = player == null ? null : new PlayerEntity(player);
        this.zzamo = participant.getCapabilities();
        this.zzbdI = participant.getResult();
        this.zzaXh = participant.getIconImageUrl();
        this.zzaXi = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.zzaZX = string;
        this.zzaiX = string2;
        this.zzaWW = uri;
        this.zzaWX = uri2;
        this.zzJh = n2;
        this.zzaYN = string3;
        this.zzbdH = bl;
        this.zzaYi = playerEntity;
        this.zzamo = n3;
        this.zzbdI = participantResult;
        this.zzaXh = string4;
        this.zzaXi = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzJh;
    }

    @Override
    public String zzDY() {
        return this.zzaYN;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzbdH;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaYi == null) {
            return this.zzaiX;
        }
        return this.zzaYi.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaYi == null) {
            zzg.zzb((String)this.zzaiX, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaYi.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaYi == null) {
            return this.zzaWW;
        }
        return this.zzaYi.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaYi == null) {
            return this.zzaXh;
        }
        return this.zzaYi.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaYi == null) {
            return this.zzaWX;
        }
        return this.zzaYi.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaYi == null) {
            return this.zzaXi;
        }
        return this.zzaYi.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaZX;
    }

    @Override
    public Player getPlayer() {
        return this.zzaYi;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzbdI;
    }

    @Override
    public int getCapabilities() {
        return this.zzamo;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzaa.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzDY(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzaa.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzaa.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzaa.equal((Object)participant2.zzDY(), (Object)participant.zzDY()) && zzaa.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzaa.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzaa.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzaa.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzaa.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzaa.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzaa.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzaa.zzv((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzDY()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ParticipantEntityCreator.zza(this, parcel, n);
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzfO(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzxo());
            if (bl || ParticipantEntity.zzdp((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzfO(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfO(parcel);
        }
    }
}

