/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaZu;
    private final String zzbdW;
    private final long zzbdA;
    private final int zzbdX;
    private final String zzacd;
    private final int zzbdE;
    private final Bundle zzbdU;
    private final ArrayList<ParticipantEntity> zzbdD;
    private final int zzbdY;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.zzaZu = room.getRoomId();
        this.zzbdW = room.getCreatorId();
        this.zzbdA = room.getCreationTimestamp();
        this.zzbdX = room.getStatus();
        this.zzacd = room.getDescription();
        this.zzbdE = room.getVariant();
        this.zzbdU = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzbdD = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbdD.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzbdY = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int n, String string, String string2, long l, int n2, String string3, int n3, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n4) {
        this.mVersionCode = n;
        this.zzaZu = string;
        this.zzbdW = string2;
        this.zzbdA = l;
        this.zzbdX = n2;
        this.zzacd = string3;
        this.zzbdE = n3;
        this.zzbdU = bundle;
        this.zzbdD = arrayList;
        this.zzbdY = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.zzaZu;
    }

    @Override
    public String getCreatorId() {
        return this.zzbdW;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzbdA;
    }

    @Override
    public int getStatus() {
        return this.zzbdX;
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.zzbdE;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzbdU;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbdD);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzbdY;
    }

    @Override
    public int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzaa.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzaa.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzaa.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzaa.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzaa.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzaa.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzaa.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzaa.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzaa.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzaa.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzaa.zzv((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        RoomEntityCreator.zza(this, parcel, n);
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzfR(Parcel parcel) {
            boolean bl = RoomEntity.zzf(RoomEntity.zzxo());
            if (bl || RoomEntity.zzdp((String)RoomEntity.class.getCanonicalName())) {
                return super.zzfR(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            String string3 = parcel.readString();
            int n2 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(2, string, string2, l, n, string3, n2, bundle, arrayList, -1);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfR(parcel);
        }
    }
}

