/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import java.util.ArrayList;

public final class RoomRef
extends zzc
implements Room {
    private final int zzaYG;

    RoomRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzaYG = n2;
    }

    @Override
    public String getRoomId() {
        return this.getString("external_match_id");
    }

    @Override
    public String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n = this.getInteger("automatch_min_players");
        int n2 = this.getInteger("automatch_max_players");
        long l = this.getLong("automatch_bit_mask");
        return RoomConfig.createAutoMatchCriteria(n, n2, l);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.zzaYG);
        for (int i = 0; i < this.zzaYG; ++i) {
            arrayList.add(new ParticipantRef(this.zzazI, this.zzaCm + i));
        }
        return arrayList;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.getInteger("automatch_wait_estimate_sec");
    }

    @Override
    public int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public Room freeze() {
        return new RoomEntity(this);
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    public boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        RoomEntity roomEntity = (RoomEntity)((Room)this.freeze());
        roomEntity.writeToParcel(parcel, n);
    }
}

