/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends GamesAbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzbbQ;
    private final String zzaZP;
    private final String zzbdW;
    private final long zzbdA;
    private final String zzbee;
    private final long zzaYl;
    private final String zzbef;
    private final int zzbeg;
    private final int zzbdE;
    private final int mVersion;
    private final byte[] zzbeh;
    private final ArrayList<ParticipantEntity> zzbdD;
    private final String zzbei;
    private final byte[] zzbej;
    private final int zzbek;
    private final Bundle zzbdU;
    private final int zzbel;
    private final boolean zzbem;
    private final String zzacd;
    private final String zzben;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.mVersionCode = 2;
        this.zzbbQ = new GameEntity(turnBasedMatch.getGame());
        this.zzaZP = turnBasedMatch.getMatchId();
        this.zzbdW = turnBasedMatch.getCreatorId();
        this.zzbdA = turnBasedMatch.getCreationTimestamp();
        this.zzbee = turnBasedMatch.getLastUpdaterId();
        this.zzaYl = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzbef = turnBasedMatch.getPendingParticipantId();
        this.zzbeg = turnBasedMatch.getStatus();
        this.zzbel = turnBasedMatch.getTurnStatus();
        this.zzbdE = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzbei = turnBasedMatch.getRematchId();
        this.zzbek = turnBasedMatch.getMatchNumber();
        this.zzbdU = turnBasedMatch.getAutoMatchCriteria();
        this.zzbem = turnBasedMatch.isLocallyModified();
        this.zzacd = turnBasedMatch.getDescription();
        this.zzben = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzbeh = null;
        } else {
            this.zzbeh = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeh, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzbej = null;
        } else {
            this.zzbej = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzbej, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzbdD = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbdD.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int n, GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n2, int n3, int n4, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n5, Bundle bundle, int n6, boolean bl, String string6, String string7) {
        this.mVersionCode = n;
        this.zzbbQ = gameEntity;
        this.zzaZP = string;
        this.zzbdW = string2;
        this.zzbdA = l;
        this.zzbee = string3;
        this.zzaYl = l2;
        this.zzbef = string4;
        this.zzbeg = n2;
        this.zzbel = n6;
        this.zzbdE = n3;
        this.mVersion = n4;
        this.zzbeh = byArray;
        this.zzbdD = arrayList;
        this.zzbei = string5;
        this.zzbej = byArray2;
        this.zzbek = n5;
        this.zzbdU = bundle;
        this.zzbem = bl;
        this.zzacd = string6;
        this.zzben = string7;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzbbQ;
    }

    @Override
    public String getMatchId() {
        return this.zzaZP;
    }

    @Override
    public String getCreatorId() {
        return this.zzbdW;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzbdA;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzbee;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYl;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzbef;
    }

    @Override
    public int getStatus() {
        return this.zzbeg;
    }

    @Override
    public int getTurnStatus() {
        return this.zzbel;
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzben;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.zzbdE;
    }

    @Override
    public byte[] getData() {
        return this.zzbeh;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzbei;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzbej;
    }

    @Override
    public int getMatchNumber() {
        return this.zzbek;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzbdU;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzbdU == null) {
            return 0;
        }
        return this.zzbdU.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzbeg == 2 && this.zzbei == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzbem;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbdD);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzaa.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzaa.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzaa.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzaa.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzaa.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzaa.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzaa.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzaa.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzaa.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzaa.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzaa.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzaa.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzaa.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzaa.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzaa.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzaa.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzaa.zzv((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

