/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends GamesAbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzbbQ;
    private final PlayerEntity zzbeA;
    private final byte[] zzbeh;
    private final String zzOn;
    private final ArrayList<PlayerEntity> zzbeB;
    private final int zzanR;
    private final long zzbdA;
    private final long zzbeC;
    private final Bundle zzbeD;
    private final int zzJh;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.zzbbQ = new GameEntity(gameRequest.getGame());
        this.zzbeA = new PlayerEntity(gameRequest.getSender());
        this.zzOn = gameRequest.getRequestId();
        this.zzanR = gameRequest.getType();
        this.zzbdA = gameRequest.getCreationTimestamp();
        this.zzbeC = gameRequest.getExpirationTimestamp();
        this.zzJh = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzbeh = null;
        } else {
            this.zzbeh = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeh, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzbeB = new ArrayList(n);
        this.zzbeD = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzbeB.add((PlayerEntity)player);
            this.zzbeD.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.zzbbQ = gameEntity;
        this.zzbeA = playerEntity;
        this.zzbeh = byArray;
        this.zzOn = string;
        this.zzbeB = arrayList;
        this.zzanR = n2;
        this.zzbdA = l;
        this.zzbeC = l2;
        this.zzbeD = bundle;
        this.zzJh = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzOn;
    }

    @Override
    public Game getGame() {
        return this.zzbbQ;
    }

    @Override
    public Player getSender() {
        return this.zzbeA;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzbeB);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzbeh;
    }

    @Override
    public int getType() {
        return this.zzanR;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzbdA;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzbeC;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.zzbeD.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzJh;
    }

    public Bundle zzFK() {
        return this.zzbeD;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzaa.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzaa.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzaa.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzaa.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzaa.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzaa.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzaa.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzaa.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzaa.zzv((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

