/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzFL();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzacd;
        private Long zzbeH;
        private Long zzbeI;
        private BitmapTeleporter zzbeJ;
        private Uri zzbeK;

        public Builder setDescription(String string) {
            this.zzacd = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.zzbeH = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.zzbeI = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.zzbeJ = new BitmapTeleporter(bitmap);
            this.zzbeK = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzacd = snapshotMetadata.getDescription();
            this.zzbeH = snapshotMetadata.getPlayedTime();
            this.zzbeI = snapshotMetadata.getProgressValue();
            if (this.zzbeH == -1L) {
                this.zzbeH = null;
            }
            this.zzbeK = snapshotMetadata.getCoverImageUri();
            if (this.zzbeK != null) {
                this.zzbeJ = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzacd, this.zzbeH, this.zzbeJ, this.zzbeK, this.zzbeI);
        }
    }
}

