/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends GamesAbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean zzbfo;
    private final boolean zzbfp;
    private final boolean zzbfq;
    private final boolean[] zzbfr;
    private final boolean[] zzbfs;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.zzbfo = bl;
        this.zzbfp = bl2;
        this.zzbfq = bl3;
        this.zzbfr = blArray;
        this.zzbfs = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.zzbfp;
    }

    public boolean isCameraSupported() {
        return this.zzbfo;
    }

    public boolean isWriteStorageSupported() {
        return this.zzbfq;
    }

    public boolean[] getSupportedCaptureModes() {
        return this.zzbfr;
    }

    public boolean[] getSupportedQualityLevels() {
        return this.zzbfs;
    }

    public boolean supportsCaptureMode(int n) {
        zzac.zzar((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzbfr[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzac.zzar((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzbfs[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.zzbfo && this.zzbfp && this.zzbfq && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzaa.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzaa.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzaa.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzaa.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzaa.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

