/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzbbl;
    protected PopupLocationInfo zzbbm;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        zzt.zzzf();
        return new PopupManagerHCMR1(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int n) {
        this.zzbbl = gamesClientImpl;
        this.zziK(n);
    }

    protected void zziK(int n) {
        this.zzbbm = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int n) {
        this.zzbbm.gravity = n;
    }

    public void zzw(View view) {
    }

    public void zzFA() {
        this.zzbbl.zza(this.zzbbm.zzbbn, this.zzbbm.zzFz());
    }

    public Bundle zzFB() {
        return this.zzbbm.zzFz();
    }

    public IBinder zzFC() {
        return this.zzbbm.zzbbn;
    }

    public PopupLocationInfo zzFD() {
        return this.zzbbm;
    }

    public static final class PopupLocationInfo {
        public IBinder zzbbn;
        public int gravity;
        public int zzbbo = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int n, IBinder iBinder) {
            this.gravity = n;
            this.zzbbn = iBinder;
        }

        public Bundle zzFz() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzbbo);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    @TargetApi(value=12)
    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzbbp;
        private boolean zzaZy = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int n) {
            super(gamesClientImpl, n);
        }

        @Override
        protected void zziK(int n) {
            this.zzbbm = new PopupLocationInfo(n, null);
        }

        @Override
        @TargetApi(value=16)
        public void zzw(View view) {
            Context context;
            View view2;
            this.zzbbl.zzFl();
            if (this.zzbbp != null) {
                view2 = (View)this.zzbbp.get();
                context = this.zzbbl.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzt.zzzi()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzbbp = null;
            view2 = this.zzbbl.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzF("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzx(view);
                this.zzbbp = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzG("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzFA() {
            if (this.zzbbm.zzbbn != null) {
                super.zzFA();
                return;
            }
            this.zzaZy = this.zzbbp != null;
        }

        public void onViewAttachedToWindow(View view) {
            this.zzx(view);
        }

        public void onViewDetachedFromWindow(View view) {
            this.zzbbl.zzFl();
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzbbp == null) {
                return;
            }
            View view = (View)this.zzbbp.get();
            if (view == null) {
                return;
            }
            this.zzx(view);
        }

        @TargetApi(value=17)
        private void zzx(View view) {
            Display display;
            int n = -1;
            if (zzt.zzzj()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzbbm.zzbbo = n;
            this.zzbbm.zzbbn = display;
            this.zzbbm.left = nArray[0];
            this.zzbbm.top = nArray[1];
            this.zzbbm.right = nArray[0] + n2;
            this.zzbbm.bottom = nArray[1] + n3;
            if (this.zzaZy) {
                this.zzFA();
                this.zzaZy = false;
            }
        }
    }
}

