/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzbdF;
    private final String zzbdG;
    private final String zzbdH;
    private final long zzbdI;
    private final long zzbdJ;
    private final String zzbdK;
    private final Uri zzbdL;
    private final Uri zzbdM;
    private final PlayerEntity zzbdN;
    private final String zzbdO;
    private final String zzbdP;
    private final String zzbdQ;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzbdF = leaderboardScore.getRank();
        this.zzbdG = (String)zzac.zzw((Object)leaderboardScore.getDisplayRank());
        this.zzbdH = (String)zzac.zzw((Object)leaderboardScore.getDisplayScore());
        this.zzbdI = leaderboardScore.getRawScore();
        this.zzbdJ = leaderboardScore.getTimestampMillis();
        this.zzbdK = leaderboardScore.getScoreHolderDisplayName();
        this.zzbdL = leaderboardScore.getScoreHolderIconImageUri();
        this.zzbdM = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzbdN = player == null ? null : (PlayerEntity)player.freeze();
        this.zzbdO = leaderboardScore.getScoreTag();
        this.zzbdP = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzbdQ = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzbdF;
    }

    @Override
    public String getDisplayRank() {
        return this.zzbdG;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzbdG, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.zzbdH;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzbdH, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.zzbdI;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzbdJ;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzbdN == null) {
            return this.zzbdK;
        }
        return this.zzbdN.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzbdN == null) {
            zzh.zzb((String)this.zzbdK, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzbdN.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzbdN == null) {
            return this.zzbdL;
        }
        return this.zzbdN.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzbdN == null) {
            return this.zzbdP;
        }
        return this.zzbdN.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzbdN == null) {
            return this.zzbdM;
        }
        return this.zzbdN.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzbdN == null) {
            return this.zzbdQ;
        }
        return this.zzbdN.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzbdN;
    }

    @Override
    public String getScoreTag() {
        return this.zzbdO;
    }

    public LeaderboardScore zzGo() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzaa.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzaa.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzaa.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzaa.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzaa.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzaa.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzaa.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzaa.zzv((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzGo();
    }
}

