/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final String zzbaC;
    private final String zzakb;
    private final Uri zzaXy;
    private final Uri zzaXz;
    private final int zzJO;
    private final String zzaZr;
    private final boolean zzbel;
    private final PlayerEntity zzaYM;
    private final int zzanu;
    private final ParticipantResult zzbem;
    private final String zzaXJ;
    private final String zzaXK;

    public ParticipantEntity(Participant participant) {
        this.zzbaC = participant.getParticipantId();
        this.zzakb = participant.getDisplayName();
        this.zzaXy = participant.getIconImageUri();
        this.zzaXz = participant.getHiResImageUri();
        this.zzJO = participant.getStatus();
        this.zzaZr = participant.zzEL();
        this.zzbel = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaYM = player == null ? null : new PlayerEntity(player);
        this.zzanu = participant.getCapabilities();
        this.zzbem = participant.getResult();
        this.zzaXJ = participant.getIconImageUrl();
        this.zzaXK = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzbaC = string;
        this.zzakb = string2;
        this.zzaXy = uri;
        this.zzaXz = uri2;
        this.zzJO = n;
        this.zzaZr = string3;
        this.zzbel = bl;
        this.zzaYM = playerEntity;
        this.zzanu = n2;
        this.zzbem = participantResult;
        this.zzaXJ = string4;
        this.zzaXK = string5;
    }

    @Override
    public int getStatus() {
        return this.zzJO;
    }

    @Override
    public String zzEL() {
        return this.zzaZr;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzbel;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaYM == null) {
            return this.zzakb;
        }
        return this.zzaYM.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaYM == null) {
            zzh.zzb((String)this.zzakb, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaYM.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaYM == null) {
            return this.zzaXy;
        }
        return this.zzaYM.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaYM == null) {
            return this.zzaXJ;
        }
        return this.zzaYM.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaYM == null) {
            return this.zzaXz;
        }
        return this.zzaYM.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaYM == null) {
            return this.zzaXK;
        }
        return this.zzaYM.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzbaC;
    }

    @Override
    public Player getPlayer() {
        return this.zzaYM;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzbem;
    }

    @Override
    public int getCapabilities() {
        return this.zzanu;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzaa.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzEL(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzaa.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzaa.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzaa.equal((Object)participant2.zzEL(), (Object)participant.zzEL()) && zzaa.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzaa.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzaa.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzaa.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzaa.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzaa.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzaa.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzaa.zzv((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzEL()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ParticipantEntityCreator.zza(this, parcel, n);
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzfT(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzxV());
            if (bl || ParticipantEntity.zzdl((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzfT(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfT(parcel);
        }
    }
}

