/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzben;

    public ParticipantRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzben = new PlayerRef(dataHolder, n);
    }

    public Participant freeze() {
        return new ParticipantEntity(this);
    }

    @Override
    public int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public String zzEL() {
        return this.getString("client_address");
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public String getDisplayName() {
        if (this.zzdh("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzben.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzdh("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.zzben.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzdh("external_player_id")) {
            return this.zzdg("default_display_image_uri");
        }
        return this.zzben.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzdh("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzben.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzdh("external_player_id")) {
            return this.zzdg("default_display_hi_res_image_uri");
        }
        return this.zzben.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzdh("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.zzben.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public Player getPlayer() {
        if (this.zzdh("external_player_id")) {
            return null;
        }
        return this.zzben;
    }

    @Override
    public ParticipantResult getResult() {
        if (this.zzdh("result_type")) {
            return null;
        }
        int n = this.getInteger("result_type");
        int n2 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    public int getCapabilities() {
        return this.getInteger("capabilities");
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        ParticipantEntity participantEntity = (ParticipantEntity)((Participant)this.freeze());
        participantEntity.writeToParcel(parcel, n);
    }
}

