/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends zza {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzbfX;
    private final int zzbfQ;
    private final String zzbfY;
    private final String zzbfZ;
    private final String zzbga;
    private final String zzbgb;
    private final boolean zzbgc;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzac.zzax((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzac.zzax((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzbfX = n;
        this.zzbfQ = n2;
        this.zzbgc = bl;
        if (n2 == 1) {
            this.zzbfZ = string2;
            this.zzbfY = string;
            this.zzbga = string3;
            this.zzbgb = string4;
        } else {
            zzac.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzac.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzac.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzac.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.zzbfZ = null;
            this.zzbfY = null;
            this.zzbga = null;
            this.zzbgb = null;
        }
    }

    public int getQualityLevel() {
        return this.zzbfX;
    }

    public int getCaptureMode() {
        return this.zzbfQ;
    }

    public String zzGF() {
        return this.zzbfZ;
    }

    public String getStreamUrl() {
        return this.zzbfY;
    }

    public String zzGG() {
        return this.zzbga;
    }

    public String zzGH() {
        return this.zzbgb;
    }

    public boolean zzGI() {
        return this.zzbgc;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzbfX;
        private int zzbfQ;
        private boolean zzbgc;
        private String zzbfY;
        private String zzbfZ;
        private String zzbga;
        private String zzbgb;

        public Builder(int n, int n2) {
            this.zzbfX = n;
            this.zzbfQ = n2;
            this.zzbgc = true;
            this.zzbfY = null;
            this.zzbfZ = null;
            this.zzbga = null;
            this.zzbgb = null;
        }

        public Builder setQualityLevel(int n) {
            this.zzbfX = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.zzbfQ = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.zzbfX, this.zzbfQ, null, null, null, null, this.zzbgc);
        }
    }
}

