/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzaYD;
    private final PlayerLevelInfo zzaYm;
    private final MostRecentGameInfoRef zzaYE;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.zzaYD = new PlayerColumnNames(string);
        this.zzaYE = new MostRecentGameInfoRef(dataHolder, n, this.zzaYD);
        if (this.zzDX()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.zzaYD.zzbcU);
            int n3 = this.getInteger(this.zzaYD.zzbcX);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.zzaYD.zzbcV), this.getLong(this.zzaYD.zzbcW));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.zzaYD.zzbcW), this.getLong(this.zzaYD.zzbcY));
            }
            this.zzaYm = new PlayerLevelInfo(this.getLong(this.zzaYD.zzbcT), this.getLong(this.zzaYD.zzbcZ), playerLevel, playerLevel2);
        } else {
            this.zzaYm = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzaYD.zzbcK);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzaYD.zzbcL);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaYD.zzbcL, charArrayBuffer);
    }

    @Override
    public String zzDQ() {
        return this.getString(this.zzaYD.zzbdj);
    }

    @Override
    public String getName() {
        return this.getString(this.zzaYD.name);
    }

    @Override
    public boolean zzDR() {
        return this.getBoolean(this.zzaYD.zzbdi);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzdg(this.zzaYD.zzbcM);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzaYD.zzbcN);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzdg(this.zzaYD.zzbcO);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzaYD.zzbcP);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzaYD.zzbcQ);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzdf(this.zzaYD.zzbcS) || this.zzdh(this.zzaYD.zzbcS)) {
            return -1L;
        }
        return this.getLong(this.zzaYD.zzbcS);
    }

    @Override
    public int zzDS() {
        return this.getInteger(this.zzaYD.zzbcR);
    }

    @Override
    public boolean zzDT() {
        return this.getBoolean(this.zzaYD.zzbdb);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzaYD.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaYD.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaYm;
    }

    @Override
    public MostRecentGameInfo zzDU() {
        if (this.zzdh(this.zzaYD.zzbdc)) {
            return null;
        }
        return this.zzaYE;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzdg(this.zzaYD.zzbdk);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zzaYD.zzbdl);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzdg(this.zzaYD.zzbdm);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zzaYD.zzbdn);
    }

    @Override
    public int zzDV() {
        return this.getInteger(this.zzaYD.zzbdo);
    }

    @Override
    public long zzDW() {
        return this.getLong(this.zzaYD.zzbdp);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.zzaYD.zzbdq);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zza(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzDX() {
        if (this.zzdh(this.zzaYD.zzbcT)) {
            return false;
        }
        return this.getLong(this.zzaYD.zzbcT) != -1L;
    }
}

