/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.internal.zzaad;

public final class LeaderboardsImpl
implements Leaderboards {
    @Override
    public Intent getAllLeaderboardsIntent(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzES();
    }

    @Override
    public Intent getLeaderboardIntent(GoogleApiClient googleApiClient, String string) {
        return this.getLeaderboardIntent(googleApiClient, string, -1);
    }

    @Override
    public Intent getLeaderboardIntent(GoogleApiClient googleApiClient, String string, int n) {
        return this.getLeaderboardIntent(googleApiClient, string, n, -1);
    }

    @Override
    public Intent getLeaderboardIntent(GoogleApiClient googleApiClient, String string, int n, int n2) {
        return Games.zzi(googleApiClient).zzl(string, n, n2);
    }

    @Override
    public PendingResult<Leaderboards.LeaderboardMetadataResult> loadLeaderboardMetadata(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new LoadMetadataImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzaad.zzb<Leaderboards.LeaderboardMetadataResult>)this, bl);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LeaderboardMetadataResult> loadLeaderboardMetadata(GoogleApiClient googleApiClient, final String string, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new LoadMetadataImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzaad.zzb<Leaderboards.LeaderboardMetadataResult>)this, string, bl);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadPlayerScoreResult> loadCurrentPlayerLeaderboardScore(GoogleApiClient googleApiClient, final String string, final int n, final int n2) {
        return googleApiClient.zza((zzaad.zza)new LoadPlayerScoreImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzaad.zzb<Leaderboards.LoadPlayerScoreResult>)this, null, string, n, n2);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadTopScores(GoogleApiClient googleApiClient, String string, int n, int n2, int n3) {
        return this.loadTopScores(googleApiClient, string, n, n2, n3, false);
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadTopScores(GoogleApiClient googleApiClient, final String string, final int n, final int n2, final int n3, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new LoadScoresImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzaad.zzb<Leaderboards.LoadScoresResult>)this, string, n, n2, n3, bl);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadPlayerCenteredScores(GoogleApiClient googleApiClient, String string, int n, int n2, int n3) {
        return this.loadPlayerCenteredScores(googleApiClient, string, n, n2, n3, false);
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadPlayerCenteredScores(GoogleApiClient googleApiClient, final String string, final int n, final int n2, final int n3, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new LoadScoresImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzaad.zzb<Leaderboards.LoadScoresResult>)this, string, n, n2, n3, bl);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadMoreScores(GoogleApiClient googleApiClient, final LeaderboardScoreBuffer leaderboardScoreBuffer, final int n, final int n2) {
        return googleApiClient.zza((zzaad.zza)new LoadScoresImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzaad.zzb<Leaderboards.LoadScoresResult>)this, leaderboardScoreBuffer, n, n2);
            }
        });
    }

    @Override
    public void submitScore(GoogleApiClient googleApiClient, String string, long l) {
        this.submitScore(googleApiClient, string, l, null);
    }

    @Override
    public void submitScore(GoogleApiClient googleApiClient, String string, long l, String string2) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            try {
                gamesClientImpl.zza(null, string, l, string2);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzF("LeaderboardsImpl", "service died");
            }
        }
    }

    @Override
    public PendingResult<Leaderboards.SubmitScoreResult> submitScoreImmediate(GoogleApiClient googleApiClient, String string, long l) {
        return this.submitScoreImmediate(googleApiClient, string, l, null);
    }

    @Override
    public PendingResult<Leaderboards.SubmitScoreResult> submitScoreImmediate(GoogleApiClient googleApiClient, final String string, final long l, final String string2) {
        return googleApiClient.zzb((zzaad.zza)new SubmitScoreImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzaad.zzb<Leaderboards.SubmitScoreResult>)this, string, l, string2);
            }
        });
    }

    protected static abstract class SubmitScoreImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.SubmitScoreResult> {
        protected SubmitScoreImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.SubmitScoreResult zzaB(final Status status) {
            return new Leaderboards.SubmitScoreResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public ScoreSubmissionData getScoreData() {
                    return new ScoreSubmissionData(DataHolder.zzcJ((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaB(status);
        }
    }

    private static abstract class LoadScoresImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LoadScoresResult> {
        private LoadScoresImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LoadScoresResult zzaA(final Status status) {
            return new Leaderboards.LoadScoresResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public Leaderboard getLeaderboard() {
                    return null;
                }

                @Override
                public LeaderboardScoreBuffer getScores() {
                    return new LeaderboardScoreBuffer(DataHolder.zzcJ((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaA(status);
        }
    }

    private static abstract class LoadPlayerScoreImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LoadPlayerScoreResult> {
        private LoadPlayerScoreImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LoadPlayerScoreResult zzaz(final Status status) {
            return new Leaderboards.LoadPlayerScoreResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public LeaderboardScore getScore() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaz(status);
        }
    }

    private static abstract class LoadMetadataImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LeaderboardMetadataResult> {
        private LoadMetadataImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LeaderboardMetadataResult zzay(final Status status) {
            return new Leaderboards.LeaderboardMetadataResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public LeaderboardBuffer getLeaderboards() {
                    return new LeaderboardBuffer(DataHolder.zzcJ((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzay(status);
        }
    }
}

