/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneRef;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntity;
import java.util.ArrayList;
import java.util.List;

public final class QuestRef
extends zzc
implements Quest {
    private final Game zzbdD;
    private final int zzaZk;

    QuestRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzbdD = new GameRef(dataHolder, n);
        this.zzaZk = n2;
    }

    @Override
    public String getQuestId() {
        return this.getString("external_quest_id");
    }

    @Override
    public String getName() {
        return this.getString("quest_name");
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_name", charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.getString("quest_description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_description", charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzdg("quest_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("quest_icon_image_url");
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzdg("quest_banner_image_uri");
    }

    @Override
    public String getBannerImageUrl() {
        return this.getString("quest_banner_image_url");
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzGw().get(0);
    }

    @Override
    public List<Milestone> zzGw() {
        ArrayList<Milestone> arrayList = new ArrayList<Milestone>(this.zzaZk);
        for (int i = 0; i < this.zzaZk; ++i) {
            arrayList.add(new MilestoneRef(this.zzaBi, this.zzaDL + i));
        }
        return arrayList;
    }

    @Override
    public Game getGame() {
        return this.zzbdD;
    }

    @Override
    public int getState() {
        return this.getInteger("quest_state");
    }

    @Override
    public int getType() {
        return this.getInteger("quest_type");
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.getLong("accepted_ts");
    }

    @Override
    public long getEndTimestamp() {
        return this.getLong("quest_end_ts");
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("quest_last_updated_ts");
    }

    @Override
    public long zzGx() {
        return this.getLong("notification_ts");
    }

    @Override
    public long getStartTimestamp() {
        return this.getLong("quest_start_ts");
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzGx() <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return new QuestEntity(this);
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntity questEntity = (QuestEntity)((Quest)this.freeze());
        questEntity.writeToParcel(parcel, n);
    }
}

