/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends GamesAbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final GameEntity zzbcv;
    private final PlayerEntity zzbfe;
    private final byte[] zzbeL;
    private final String zzOV;
    private final ArrayList<PlayerEntity> zzbff;
    private final int zzakD;
    private final long mCreationTimestamp;
    private final long zzbfg;
    private final Bundle zzbfh;
    private final int zzJO;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzbcv = new GameEntity(gameRequest.getGame());
        this.zzbfe = new PlayerEntity(gameRequest.getSender());
        this.zzOV = gameRequest.getRequestId();
        this.zzakD = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzbfg = gameRequest.getExpirationTimestamp();
        this.zzJO = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzbeL = null;
        } else {
            this.zzbeL = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeL, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzbff = new ArrayList(n);
        this.zzbfh = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzbff.add((PlayerEntity)player);
            this.zzbfh.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzbcv = gameEntity;
        this.zzbfe = playerEntity;
        this.zzbeL = byArray;
        this.zzOV = string;
        this.zzbff = arrayList;
        this.zzakD = n;
        this.mCreationTimestamp = l;
        this.zzbfg = l2;
        this.zzbfh = bundle;
        this.zzJO = n2;
    }

    @Override
    public String getRequestId() {
        return this.zzOV;
    }

    @Override
    public Game getGame() {
        return this.zzbcv;
    }

    @Override
    public Player getSender() {
        return this.zzbfe;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzbff);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzbeL;
    }

    @Override
    public int getType() {
        return this.zzakD;
    }

    @Override
    public long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzbfg;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.zzbfh.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzJO;
    }

    public Bundle zzGy() {
        return this.zzbfh;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzaa.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzaa.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzaa.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzaa.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzaa.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzaa.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzaa.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzaa.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzaa.zzv((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

