/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzg;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzaxp;
    private String zzalR;
    private final Uri zzaXY;
    private final Uri zzaXZ;
    private final long zzaYI;
    private final int zzaYJ;
    private final long zzaYK;
    private final String zzaYj;
    private final String zzaYk;
    private final String zzaoA;
    private final zzb zzaYL;
    private final PlayerLevelInfo zzaYM;
    private final boolean zzaYN;
    private final boolean zzaYO;
    private final String zzaYP;
    private final String mName;
    private final Uri zzaYQ;
    private final String zzaYR;
    private final Uri zzaYS;
    private final String zzaYT;
    private final int zzaYU;
    private final long zzaYV;
    private final boolean zzacA;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzaxp = player.getPlayerId();
        this.zzalR = player.getDisplayName();
        this.zzaXY = player.getIconImageUri();
        this.zzaYj = player.getIconImageUrl();
        this.zzaXZ = player.getHiResImageUri();
        this.zzaYk = player.getHiResImageUrl();
        this.zzaYI = player.getRetrievedTimestamp();
        this.zzaYJ = player.zzuk();
        this.zzaYK = player.getLastPlayedWithTimestamp();
        this.zzaoA = player.getTitle();
        this.zzaYN = player.zzul();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzum();
        this.zzaYL = zza2 == null ? null : new zzb(zza2);
        this.zzaYM = player.getLevelInfo();
        this.zzaYO = player.zzuj();
        this.zzaYP = player.zzui();
        this.mName = player.getName();
        this.zzaYQ = player.getBannerImageLandscapeUri();
        this.zzaYR = player.getBannerImageLandscapeUrl();
        this.zzaYS = player.getBannerImagePortraitUri();
        this.zzaYT = player.getBannerImagePortraitUrl();
        this.zzaYU = player.zzun();
        this.zzaYV = player.zzuo();
        this.zzacA = player.isMuted();
        zzc.zzr((Object)this.zzaxp);
        zzc.zzr((Object)this.zzalR);
        zzc.zzae((this.zzaYI > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzaxp = string;
        this.zzalR = string2;
        this.zzaXY = uri;
        this.zzaYj = string3;
        this.zzaXZ = uri2;
        this.zzaYk = string4;
        this.zzaYI = l;
        this.zzaYJ = n;
        this.zzaYK = l2;
        this.zzaoA = string5;
        this.zzaYN = bl;
        this.zzaYL = zzb2;
        this.zzaYM = playerLevelInfo;
        this.zzaYO = bl2;
        this.zzaYP = string6;
        this.mName = string7;
        this.zzaYQ = uri3;
        this.zzaYR = string8;
        this.zzaYS = uri4;
        this.zzaYT = string9;
        this.zzaYU = n2;
        this.zzaYV = l3;
        this.zzacA = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzaxp;
    }

    @Override
    public final String getDisplayName() {
        return this.zzalR;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzalR, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzui() {
        return this.zzaYP;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzuj() {
        return this.zzaYO;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzaXY;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzaYj;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzaXZ;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzaYk;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzaYI;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzaYK;
    }

    @Override
    public final int zzuk() {
        return this.zzaYJ;
    }

    @Override
    public final boolean zzul() {
        return this.zzaYN;
    }

    @Override
    public final String getTitle() {
        return this.zzaoA;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzaoA, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzaYM;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzum() {
        return this.zzaYL;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzaYQ;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzaYR;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzaYS;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzaYT;
    }

    @Override
    public final int zzun() {
        return this.zzaYU;
    }

    @Override
    public final long zzuo() {
        return this.zzaYV;
    }

    @Override
    public final boolean isMuted() {
        return this.zzacA;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzuj(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzui(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzun(), player.zzuo(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbh.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbh.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbh.equal((Object)player2.zzuj(), (Object)player.zzuj()) && zzbh.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbh.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbh.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbh.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbh.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbh.equal((Object)player2.zzui(), (Object)player.zzui()) && zzbh.equal((Object)player2.getName(), (Object)player.getName()) && zzbh.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbh.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbh.equal((Object)player2.zzun(), (Object)player.zzun()) && zzbh.equal((Object)player2.zzuo(), (Object)player.zzuo()) && zzbh.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbh.zzt((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzuj()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzui()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzun()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzuo()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzd.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzaYJ);
        zzd.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzaYL, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzaYN);
        zzd.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzaYO);
        zzd.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzaYP, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzaYU);
        zzd.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzaYV);
        zzd.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzacA);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzg {
        zza() {
        }

        @Override
        public final PlayerEntity zzg(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzrv()) || PlayerEntity.zzcA((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzg(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzg(parcel);
        }
    }
}

