/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzaZf;
    private final int zzamt;
    private final String mName;
    private final String zzafc;
    private final Uri zzaZg;
    private final String zzaZh;
    private final Uri zzaZi;
    private final String zzaZj;
    private final int zzaZk;
    private final String zzaZl;
    private final PlayerEntity zzaZm;
    private final int mState;
    private final int zzaZn;
    private final String zzaZo;
    private final long zzaZp;
    private final long zzaZq;

    public AchievementEntity(Achievement achievement) {
        this.zzaZf = achievement.getAchievementId();
        this.zzamt = achievement.getType();
        this.mName = achievement.getName();
        this.zzafc = achievement.getDescription();
        this.zzaZg = achievement.getUnlockedImageUri();
        this.zzaZh = achievement.getUnlockedImageUrl();
        this.zzaZi = achievement.getRevealedImageUri();
        this.zzaZj = achievement.getRevealedImageUrl();
        this.zzaZm = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaZp = achievement.getLastUpdatedTimestamp();
        this.zzaZq = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaZk = achievement.getTotalSteps();
            this.zzaZl = achievement.getFormattedTotalSteps();
            this.zzaZn = achievement.getCurrentSteps();
            this.zzaZo = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaZk = 0;
            this.zzaZl = null;
            this.zzaZn = 0;
            this.zzaZo = null;
        }
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzaZf);
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzafc);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzaZf = string;
        this.zzamt = n;
        this.mName = string2;
        this.zzafc = string3;
        this.zzaZg = uri;
        this.zzaZh = string4;
        this.zzaZi = uri2;
        this.zzaZj = string5;
        this.zzaZk = n2;
        this.zzaZl = string6;
        this.zzaZm = playerEntity;
        this.mState = n3;
        this.zzaZn = n4;
        this.zzaZo = string7;
        this.zzaZp = l;
        this.zzaZq = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzaZf;
    }

    @Override
    public final int getType() {
        return this.zzamt;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzafc;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzafc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzaZg;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzaZh;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzaZi;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzaZj;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZk;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZl;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        zzi.zzb((String)this.zzaZl, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzaZm;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZn;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZo;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        zzi.zzb((String)this.zzaZo, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzaZp;
    }

    @Override
    public final long getXpValue() {
        return this.zzaZq;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbh.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbh.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbh.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbh.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbh.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbh.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbh.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbh.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbh.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbh.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbj zzbj2 = zzbh.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbj2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbj2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbj2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzd.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzaZk);
        zzd.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzaZl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzaZn);
        zzd.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzaZo, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

