/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzbcP;
    private final String zzalR;
    private final Uri zzaXY;
    private final int zzbcQ;
    private final ArrayList<zzb> zzbcR;
    private final Game zzbcS;
    private final String zzaYj;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzbcP = leaderboard.getLeaderboardId();
        this.zzalR = leaderboard.getDisplayName();
        this.zzaXY = leaderboard.getIconImageUri();
        this.zzaYj = leaderboard.getIconImageUrl();
        this.zzbcQ = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzbcS = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzbcR = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbcR.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zzbcP;
    }

    @Override
    public final String getDisplayName() {
        return this.zzalR;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzalR, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzaXY;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzaYj;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzbcQ;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzbcR);
    }

    @Override
    public final Game getGame() {
        return this.zzbcS;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbh.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbh.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbh.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbh.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbh.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbh.zzt((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }
}

